/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control.ds;

import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.control.ds.DBPoolClassUtil;
import whatap.agent.counter.task.pools.other.WebLogicDS10;
import whatap.agent.trace.ConPool;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.util.CastUtil;
import whatap.util.StringEnumer;
import whatap.util.StringUtil;

public class ConnPoolStatusProxy {
    static Configure conf = Configure.getInstance();

    public static MapValue getDataSourceInfo(String fContext, String fName, String fKey) {
        MapValue result = new MapValue();
        ListValue context = result.newList("context");
        ListValue name = result.newList("name");
        ListValue key = result.newList("key");
        ListValue value = result.newList("value");
        if (context.size() > 0) {
            result = new MapValue();
            ListValue contextOut = result.newList("context");
            ListValue nameOut = result.newList("name");
            ListValue keyOut = result.newList("key");
            ListValue valueOut = result.newList("value");
            boolean hasFilter = StringUtil.isNotEmpty(fContext) || StringUtil.isNotEmpty(fName) || StringUtil.isNotEmpty(fKey);
            for (int i = 0; i < context.size(); ++i) {
                if (hasFilter && (!ConnPoolStatusProxy.has(i, context, fContext) || !ConnPoolStatusProxy.has(i, name, fName) || !ConnPoolStatusProxy.has(i, key, fKey))) continue;
                ConnPoolStatusProxy.copy(i, context, contextOut);
                ConnPoolStatusProxy.copy(i, name, nameOut);
                ConnPoolStatusProxy.copy(i, key, keyOut);
                ConnPoolStatusProxy.copy(i, value, valueOut);
            }
            return result;
        }
        if (ConfPool.tomcat_ds_enabled) {
            try {
                ConnPoolStatusProxy.tomcat(result, fContext, fName, fKey);
            }
            catch (Exception e) {
                Logger.println("A214", 10, "tomcat_ds_enabled", e);
            }
        }
        if (ConfPool.weblogic_ds_enabled) {
            try {
                WebLogicDS10.getJDBCRuntime(result, fContext, fName, fKey);
            }
            catch (Exception e) {
                Logger.println("A215", 10, "weblogic_ds_enabled", e);
            }
        }
        StringEnumer en = ConPool.keys();
        while (en.hasMoreElements()) {
            String poolKey = en.nextString();
            try {
                DBPoolClassUtil.readDbPoolStatus(poolKey, result, fContext, fName, fKey);
            }
            catch (Exception e) {
                Logger.println("A215", 10, poolKey + ":" + e, e);
            }
        }
        return result;
    }

    private static void tomcat(MapValue result, String fContext, String fName, String fKey) throws Exception {
        boolean hasFilter;
        ListValue context = result.newList("context");
        ListValue name = result.newList("name");
        ListValue key = result.newList("key");
        ListValue value = result.newList("value");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> ds = server.queryNames(null, new ObjectName("*:type=DataSource,*"));
        Iterator<ObjectName> itr = ds.iterator();
        boolean bl = hasFilter = StringUtil.isNotEmpty(fContext) || StringUtil.isNotEmpty(fName) || StringUtil.isNotEmpty(fKey);
        while (itr.hasNext()) {
            ObjectName o = itr.next();
            String c = o.getKeyProperty("context");
            String n = o.getKeyProperty("name");
            c = ConnPoolStatusProxy.wrap(c);
            n = ConnPoolStatusProxy.wrap(n);
            MBeanInfo mi = server.getMBeanInfo(o);
            MBeanAttributeInfo[] a = mi.getAttributes();
            for (int j = 0; j < a.length; ++j) {
                if (!a[j].isReadable()) continue;
                try {
                    String k = a[j].getName();
                    String v = StringUtil.trimEmpty(CastUtil.cString(server.getAttribute(o, a[j].getName())));
                    if (hasFilter && (!ConnPoolStatusProxy.has(c, fContext) || !ConnPoolStatusProxy.has(n, fName) || !ConnPoolStatusProxy.has(k, fKey))) continue;
                    context.add(c);
                    name.add(n);
                    key.add(k);
                    value.add(v);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static String wrap(String c) {
        if (c == null) {
            return "";
        }
        if (c.startsWith("\"")) {
            return c;
        }
        return '\"' + c + '\"';
    }

    private static boolean has(String k, String filter) {
        if (StringUtil.isEmpty(filter)) {
            return true;
        }
        return k.contains(filter);
    }

    public static void main(String[] args) {
    }

    private static boolean has(int i, ListValue x, String filter) {
        if (StringUtil.isEmpty(filter)) {
            return true;
        }
        String s = i < x.size() ? x.getString(i) : "";
        return s.indexOf(filter) >= 0;
    }

    private static void copy(int i, ListValue src, ListValue dest) {
        if (src.size() > i) {
            dest.add(src.get(i));
        } else {
            dest.add("");
        }
    }
}

