/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import whatap.Version;
import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.tools.KubeUtil;
import whatap.lang.value.MapValue;
import whatap.util.IPUtil;
import whatap.util.SysJMX;

public class AgentDataHelp {
    public static MapValue getinfo() {
        Configure conf = Configure.getInstance();
        SecurityMaster se = SecurityMaster.getInstance();
        MapValue m = new MapValue();
        m.put("pcode", se.PCODE);
        m.put("oid", se.OID);
        m.put("oname", se.ONAME);
        m.put("start_time", SysJMX.getStartTime());
        m.put("host_name", SysJMX.getHostName());
        String addr = AgentDataHelp.getLocalIp();
        if (addr != null && addr.length() > 0) {
            m.put("local_ip", addr);
        } else {
            m.put("ip", IPUtil.toString(se.IP));
        }
        m.put("cpu_cores", Runtime.getRuntime().availableProcessors());
        m.put("pid", SysJMX.getProcessPID());
        if (KubeUtil.container_id != null) {
            m.put("container_id", KubeUtil.container_id);
        }
        if (conf.OKIND != 0) {
            m.put("okind", conf.OKIND);
            m.put("okind_name", conf.OKIND_NAME);
        }
        if (conf.ONODE != 0) {
            m.put("onode", conf.ONODE);
            m.put("oname_name", conf.ONODE_NAME);
        }
        m.put("version", Version.getVersion());
        m.put("build", Version.getBuild());
        return m;
    }

    public static String getLocalIp() {
        try {
            ArrayList<String> out = new ArrayList<String>();
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                    out.add(addr.getHostAddress());
                }
            }
            StringBuilder sb = new StringBuilder();
            for (String s : out) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(s);
            }
            return sb.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

