/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.boot;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfProduct;
import whatap.agent.data.DataPackSender;
import whatap.agent.tools.KubeUtil;
import whatap.lang.pack.AgentPropertyPack;
import whatap.util.AnsiPrint;
import whatap.util.DateUtil;
import whatap.util.IPUtil;
import whatap.util.StringUtil;
import whatap.util.SystemUtil;

public class AgentProperty {
    static long sent_count = 0L;
    static long last_send = 0L;
    private static long java_heap = 0L;
    private static long host_mem = 0L;

    public static synchronized void send() {
        Configure conf = Configure.getInstance();
        if (!conf.agent_property_enabled) {
            return;
        }
        SecurityMaster secu = SecurityMaster.getInstance();
        if (secu.WSID == 0) {
            return;
        }
        if (secu.SYS_ID == 0) {
            Logger.println("not ready to send agent property, sysid=0");
            return;
        }
        long now = DateUtil.nanoToMillis();
        if (sent_count < 3L ? now - last_send < 5000L : now - last_send < 300000L) {
            return;
        }
        last_send = now;
        AgentPropertyPack pack = new AgentPropertyPack();
        Properties prop = conf.property;
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("property@")) continue;
            String value = prop.getProperty(key);
            String key2 = key.substring("property@".length());
            pack.put(key2, value);
        }
        pack.put("oname", secu.ONAME);
        if (conf.OKIND != 0) {
            pack.put("okind", String.valueOf(conf.OKIND));
            pack.put("okind_name", String.valueOf(conf.OKIND_NAME));
        }
        if (conf.ONODE != 0) {
            pack.put("onode", String.valueOf(conf.ONODE));
            pack.put("onode_name", String.valueOf(conf.ONODE_NAME));
        }
        if (StringUtil.isNotEmpty(KubeUtil.container_id)) {
            pack.put("container", KubeUtil.container_id);
        }
        pack.put("obstype", ConfProduct.obstype);
        pack.put("obslevel", ConfProduct.obslevel);
        int cpu_cores = Runtime.getRuntime().availableProcessors();
        String host_ip = IPUtil.toString(secu.IP);
        pack.put("cpu_cores", String.valueOf(cpu_cores));
        pack.put("host_ip", host_ip);
        if (conf.agent_property_sys_enabled && SystemUtil.IS_JAVA_OVER9()) {
            if (java_heap >= 0L) {
                try {
                    if (java_heap == 0L) {
                        java_heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
                    }
                    if (java_heap > 0L) {
                        pack.put("java_heap", Long.toString(java_heap));
                    }
                }
                catch (Throwable t) {
                    java_heap = -1L;
                }
            }
            if (host_mem >= 0L) {
                try {
                    if (!SystemUtil.IS_JAVA_IBM) {
                        OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                        host_mem = os.getTotalPhysicalMemorySize();
                    } else {
                        host_mem = -1L;
                    }
                    if (host_mem > 0L) {
                        pack.put("host_mem", Long.toString(host_mem));
                    }
                }
                catch (Throwable t) {
                    host_mem = -1L;
                }
            }
        }
        ++sent_count;
        DataPackSender.sendToRouter(pack);
        Logger.println("AgentProperty service=" + AnsiPrint.yellow(pack.get("service")) + " anchor_id=" + AnsiPrint.yellow(pack.get("anchor_id")));
    }
}

