/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.logsink;

import java.util.HashMap;
import java.util.Map;
import whatap.agent.ClassDesc;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.logsink.LoggerUtilCV;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class LoggerUtilASM
extends IASM
implements Opcodes {
    private Map<String, HookingSet> reserved = new HashMap<String, HookingSet>();

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.reserved.keySet());
    }

    public LoggerUtilASM() {
        AsmUtil.add(this.reserved, "java/util/logging/Logger", "log(Ljava/util/logging/LogRecord;)V");
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hooklog_logger_util_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new LoggerUtilCV(cv, mset, className);
        }
        return cv;
    }
}

