/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.conf.ConfHook;
import whatap.agent.trace.TraceMain;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

class SpringExceptionHandlerMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String CLASS = TraceMain.class.getName().replace('.', '/');
    private static final String METHOD = "exception";
    private static final String SIGNATURE = "(Ljava/lang/Throwable;)V";
    private Type[] paramTypes;
    private boolean isStatic;
    private String classname;
    private String methodname;
    private String desc;

    public SpringExceptionHandlerMV(int access, String desc, MethodVisitor mv, Type[] paramTypes, boolean isStatic, String classname, String methodname, String methoddesc) {
        super(IASM.API, access, desc, mv);
        this.paramTypes = paramTypes;
        this.isStatic = isStatic;
        this.classname = classname;
        this.methodname = methodname;
        this.desc = desc;
    }

    public void visitCode() {
        boolean flag = false;
        int sidx = this.isStatic ? 0 : 1;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            Type tp = this.paramTypes[i];
            if ("java/lang/Exception".equals(tp.getInternalName()) || "java/lang/Throwable".equals(tp.getInternalName()) || ConfHook.hook_exception_classes.contains(tp.getInternalName())) {
                this.mv.visitVarInsn(25, sidx);
                flag = true;
                break;
            }
            sidx += tp.getSize();
        }
        Logger.println("ASM", "exception handler " + this.classname + "." + this.methodname + this.desc + (flag ? " ok" : " fail"));
        if (!flag) {
            this.mv.visitInsn(1);
        }
        this.mv.visitMethodInsn(184, CLASS, METHOD, SIGNATURE, false);
        super.visitCode();
    }
}

