/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.Configure;
import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.trace.TraceMain;
import whatap.org.objectweb.asm.Label;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;
import whatap.util.StringUtil;

class ServiceMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACEMAIN = TraceMain.class.getName().replace('.', '/');
    private static final String START_METHOD = "startService";
    private static final String START_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String END_METHOD = "endService";
    private static final String END_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V";
    private Label startFinally = new Label();
    private Type[] paramTypes;
    private Type returnType;
    private String classMethod;
    private int statIdx;
    private boolean isStatic;
    private String className;
    private String methodName;
    private String methodDesc;
    Configure conf = Configure.getInstance();

    public ServiceMV(int access, String desc, MethodVisitor mv, String classMethod, Type[] paramTypes, boolean isStatic, String classname, String methodname, String methoddesc) {
        super(IASM.API, access, desc, mv);
        this.classMethod = classMethod;
        this.paramTypes = paramTypes;
        this.isStatic = isStatic;
        this.returnType = Type.getReturnType(desc);
        this.className = classname;
        this.methodName = methodname;
        this.methodDesc = methoddesc;
    }

    public void visitCode() {
        int sidx = this.isStatic ? 0 : 1;
        AsmUtil.PUSH(this.mv, this.classMethod);
        int arrVarIdx = this.newLocal(Type.getType("[Ljava/lang/Object;"));
        AsmUtil.PUSH(this.mv, this.paramTypes.length);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        this.mv.visitVarInsn(58, arrVarIdx);
        for (int i = 0; i < this.paramTypes.length; ++i) {
            Type tp = this.paramTypes[i];
            this.mv.visitVarInsn(25, arrVarIdx);
            AsmUtil.PUSH(this.mv, i);
            switch (tp.getSort()) {
                case 1: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case 3: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case 2: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case 4: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                case 5: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case 7: {
                    this.mv.visitVarInsn(22, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case 6: {
                    this.mv.visitVarInsn(23, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case 8: {
                    this.mv.visitVarInsn(24, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                    break;
                }
                default: {
                    this.mv.visitVarInsn(25, sidx);
                }
            }
            this.mv.visitInsn(83);
            sidx += tp.getSize();
        }
        if (this.conf.service_name_simple_enabled) {
            AsmUtil.PUSH(this.mv, StringUtil.cutLastString(this.className, '.'));
        } else {
            AsmUtil.PUSH(this.mv, this.className);
        }
        AsmUtil.PUSH(this.mv, this.methodName);
        AsmUtil.PUSH(this.mv, this.methodDesc);
        if (this.isStatic) {
            AsmUtil.PUSHNULL(this.mv);
        } else {
            this.mv.visitVarInsn(25, 0);
        }
        this.mv.visitVarInsn(25, arrVarIdx);
        this.mv.visitMethodInsn(184, TRACEMAIN, START_METHOD, START_SIGNATURE, false);
        this.statIdx = this.newLocal(Type.getType(Object.class));
        this.mv.visitVarInsn(58, this.statIdx);
        this.mv.visitLabel(this.startFinally);
        this.mv.visitCode();
    }

    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.capReturn();
        }
        this.mv.visitInsn(opcode);
    }

    private void capReturn() {
        Type tp = this.returnType;
        if (tp == null || tp.equals(Type.VOID_TYPE)) {
            this.mv.visitVarInsn(25, this.statIdx);
            this.mv.visitInsn(1);
            this.mv.visitInsn(1);
            this.mv.visitMethodInsn(184, TRACEMAIN, END_METHOD, END_SIGNATURE, false);
            return;
        }
        int i = this.newLocal(tp);
        switch (tp.getSort()) {
            case 1: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 3: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 2: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 4: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 5: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 7: {
                this.mv.visitVarInsn(55, i);
                this.mv.visitVarInsn(22, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(22, i);
                this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 6: {
                this.mv.visitVarInsn(56, i);
                this.mv.visitVarInsn(23, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(23, i);
                this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 8: {
                this.mv.visitVarInsn(57, i);
                this.mv.visitVarInsn(24, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(24, i);
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                this.mv.visitInsn(1);
                break;
            }
            default: {
                this.mv.visitVarInsn(58, i);
                this.mv.visitVarInsn(25, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(25, i);
                this.mv.visitInsn(1);
            }
        }
        this.mv.visitMethodInsn(184, TRACEMAIN, END_METHOD, END_SIGNATURE, false);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitInsn(89);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.mv.visitVarInsn(25, this.statIdx);
        this.mv.visitInsn(1);
        this.mv.visitVarInsn(25, errIdx);
        this.mv.visitMethodInsn(184, TRACEMAIN, END_METHOD, END_SIGNATURE, false);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }
}

