/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.asm.IASM;
import whatap.agent.asm.ServiceBackgroundMV;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;

class ServiceBackgroundCV
extends ClassVisitor
implements Opcodes {
    public String className;
    private HookingSet mset;

    public ServiceBackgroundCV(ClassVisitor cv, HookingSet mset, String className) {
        super(IASM.API, cv);
        this.mset = mset;
        this.className = className;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || !this.mset.isA(name, desc)) {
            return mv;
        }
        if (AsmUtil.isInitMethod(name)) {
            return mv;
        }
        if (ConfHook.hook_service_background_ignore_patterns.contains(name)) {
            return mv;
        }
        switch (access & 7) {
            case 1: {
                if (ConfHook.hook_service_access_public_enabled) break;
                return mv;
            }
            case 4: {
                if (ConfHook.hook_service_access_protected_enabled) break;
                return mv;
            }
            case 2: {
                if (ConfHook.hook_service_access_private_enabled) break;
                return mv;
            }
            default: {
                if (ConfHook.hook_service_access_none_enabled) break;
                return mv;
            }
        }
        String classMethod = AsmUtil.makeClassAndMethod(this.className, name);
        return new ServiceBackgroundMV(access, desc, mv, classMethod, Type.getArgumentTypes(desc), (access & 8) != 0, this.className, name, desc);
    }
}

