/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.JDBCPreparedStatementASM;
import whatap.agent.asm.jdbc.PsClearParametersMV;
import whatap.agent.asm.jdbc.PsCloseMV;
import whatap.agent.asm.jdbc.PsExecute;
import whatap.agent.asm.jdbc.PsExecuteBatch;
import whatap.agent.asm.jdbc.PsExecuteBatchInternal;
import whatap.agent.asm.jdbc.PsExecuteQuery;
import whatap.agent.asm.jdbc.PsExecuteUpdate;
import whatap.agent.asm.jdbc.PsInitMV4Pre;
import whatap.agent.asm.jdbc.PsSetMV;
import whatap.agent.asm.jdbc.StExecute;
import whatap.agent.asm.jdbc.StExecuteBatch;
import whatap.agent.asm.jdbc.StExecuteQuery;
import whatap.agent.asm.jdbc.StExecuteUpdate;
import whatap.agent.conf.ConfDebug;
import whatap.agent.conf.ConfHook;
import whatap.agent.trace.SqlParameter;
import whatap.lang.slog.SLog;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.util.Pair;

class PreparedStatementCV
extends ClassVisitor
implements Opcodes {
    String className;
    private String sqlParamType;
    private String owner;

    public PreparedStatementCV(ClassVisitor cv, String sqlParamType, String className) {
        super(IASM.API, cv);
        this.sqlParamType = sqlParamType;
        this.className = className;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.owner = name;
        Logger.println("BCI", "jdbc-pstmt-owner " + name);
        if (ConfHook.sqlparam_field_enabled && !JDBCPreparedStatementASM.noField.contains(name)) {
            super.visitField(1, "_wsqlparam_", Type.getDescriptor(SqlParameter.class), null, null).visitEnd();
            if (ConfDebug.debug_hook_pstmt_set_enabled) {
                Logger.green("jdbc-pstmt-field SqlParameter for " + this.className);
            }
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("<init>".equals(name)) {
            if (!JDBCPreparedStatementASM.ignoreInit.contains(new Pair<String, String>(this.owner, desc)) && ConfHook.sqlparam_field_enabled) {
                return new PsInitMV4Pre(access, desc, mv, this.owner, this.sqlParamType);
            }
            return mv;
        }
        if ("clearParameters".equals(name) && "()V".equals(desc)) {
            if (ConfHook.sqlparam_field_enabled) {
                return new PsClearParametersMV(access, desc, mv, this.owner);
            }
            return mv;
        }
        if ("close".equals(name) && "()V".equals(desc)) {
            return new PsCloseMV(access, desc, mv, this.owner);
        }
        String targetDesc = PsSetMV.getSetSignature(this.owner, name);
        if (targetDesc != null) {
            if (desc.equals(targetDesc) || desc.startsWith(targetDesc)) {
                if (ConfDebug.debug_hook_pstmt_set_enabled) {
                    Logger.println(SLog.n("jdbc-set", this.className).yellow(name, (Object)desc).green("conf", targetDesc).str());
                }
                if (ConfHook.sqlparam_field_enabled) {
                    return new PsSetMV(access, name, desc, mv, this.owner);
                }
            }
        } else if (desc.startsWith("()")) {
            if (name.equals("execute") && desc.endsWith("Z")) {
                return new PsExecute(access, desc, mv, this.owner, name);
            }
            if (name.equals("executeUpdate") && desc.endsWith("I")) {
                return new PsExecuteUpdate(access, desc, mv, this.owner, name);
            }
            if (name.equals("executeQuery") && desc.endsWith("Ljava/sql/ResultSet;")) {
                return new PsExecuteQuery(access, desc, mv, this.owner, name);
            }
            if (name.equals("executeBatch") && desc.endsWith("[I")) {
                return new PsExecuteBatch(access, desc, mv, this.owner, name);
            }
            if (this.className.equals("com/mysql/cj/jdbc/ClientPreparedStatement") && name.equals("executeBatchInternal") && desc.endsWith("[J")) {
                return new PsExecuteBatchInternal(access, desc, mv, this.owner, name);
            }
            if (this.className.equals("software/aws/rds/jdbc/mysql/shading/com/mysql/cj/jdbc/ClientPreparedStatement") && name.equals("executeBatchInternal") && desc.endsWith("[J")) {
                return new PsExecuteBatchInternal(access, desc, mv, this.owner, name);
            }
        } else if (desc.startsWith("(Ljava/lang/String;)")) {
            if (name.equals("execute") && desc.endsWith("Z")) {
                return new StExecute(access, desc, mv, this.owner, name);
            }
            if (name.equals("executeUpdate") && desc.endsWith("I")) {
                return new StExecuteUpdate(access, desc, mv, this.owner, name);
            }
            if (name.equals("executeQuery") && desc.endsWith("Ljava/sql/ResultSet;")) {
                return new StExecuteQuery(access, desc, mv, this.owner, name);
            }
            if (name.equals("executeBatch") && desc.endsWith("[I")) {
                return new StExecuteBatch(access, desc, mv, this.owner, name);
            }
        }
        return mv;
    }
}

