/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.MethodLogMV;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;

class MethodLogCV
extends ClassVisitor
implements Opcodes {
    private String className;
    private HookingSet mset;

    public MethodLogCV(ClassVisitor cv, HookingSet mset, String className) {
        super(IASM.API, cv);
        this.mset = mset;
        this.className = className;
        Logger.println("MLOG-BCI", className);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || !this.mset.isA(name, desc)) {
            return mv;
        }
        if (name.startsWith("<")) {
            return mv;
        }
        String fullname = AsmUtil.makeMethodFullName(this.className, name, desc);
        return new MethodLogMV(access, name, desc, fullname, mv);
    }
}

