/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.MethodCompomentMV;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookComponentMap;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.HashUtil;

class MethodCompomentCV
extends ClassVisitor
implements Opcodes {
    private final String className;
    private final HookComponentMap.MethodComponentMap methodCompMap;

    public MethodCompomentCV(ClassVisitor cv, HookComponentMap.MethodComponentMap mset, String className) {
        super(IASM.API, cv);
        this.methodCompMap = mset;
        this.className = className;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || AsmUtil.isInitMethod(name)) {
            return mv;
        }
        String compName = this.methodCompMap.getComponent(name, desc);
        if (compName == null) {
            return mv;
        }
        String classMethod = AsmUtil.makeClassAndMethod(this.className, name);
        int compHash = HashUtil.hash(compName);
        Logger.println("BCI", compName + "@" + classMethod + desc);
        return new MethodCompomentMV(access, desc, mv, compHash, compName);
    }
}

