/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.asm.IASM;
import whatap.agent.asm.MethodMV;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.HashUtil;

class MethodCV
extends ClassVisitor
implements Opcodes {
    public String className;
    private HookingSet mset;

    public MethodCV(ClassVisitor cv, HookingSet mset, String className) {
        super(IASM.API, cv);
        this.mset = mset;
        this.className = className;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || !this.mset.isA(name, desc)) {
            return mv;
        }
        if (AsmUtil.isInitMethod(name)) {
            return mv;
        }
        boolean isPublic = ConfHook.hook_method_access_public_enabled;
        boolean isProtected = ConfHook.hook_method_access_protected_enabled;
        boolean isPrivate = ConfHook.hook_method_access_private_enabled;
        boolean isNone = ConfHook.hook_method_access_none_enabled;
        switch (access & 7) {
            case 1: {
                if (isPublic) break;
                return mv;
            }
            case 4: {
                if (isProtected) break;
                return mv;
            }
            case 2: {
                if (isPrivate) break;
                return mv;
            }
            default: {
                if (isNone) break;
                return mv;
            }
        }
        if (ConfHook.isIgnoreMethodPrefix(name)) {
            return mv;
        }
        String fullname = AsmUtil.makeMethodFullName(this.className, name, desc);
        int fullname_hash = HashUtil.hash(fullname);
        return new MethodMV(access, desc, mv, fullname, fullname_hash);
    }
}

