/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.Logger;
import whatap.agent.asm.HttpJakartaMV;
import whatap.agent.asm.IASM;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;

class HttpJakartaCV
extends ClassVisitor
implements Opcodes {
    private static String TARGET_SERVICE = "service";
    private static String TARGET_DOFILTER = "doFilter";
    private static String TARGET_SIGNATURE = "(Ljakarta/servlet/ServletRequest;Ljakarta/servlet/ServletResponse;";
    private static String JAVAX_SERVLET_EXCEPTION = "javax/servlet/ServletException";
    private String className;

    public HttpJakartaCV(ClassVisitor cv, String className) {
        super(IASM.API, cv);
        this.className = className;
    }

    private boolean hasJavaxServletException(String[] exceptions) {
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                if (!JAVAX_SERVLET_EXCEPTION.equals(exceptions[i])) continue;
                return true;
            }
        }
        return false;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return mv;
        }
        if (this.hasJavaxServletException(exceptions)) {
            Logger.println("BCI", "Skip jakarta " + this.className + "." + name + " due to javax.servlet.ServletException");
            return mv;
        }
        if (desc.startsWith(TARGET_SIGNATURE)) {
            if (TARGET_SERVICE.equals(name)) {
                Logger.println("ASM", "jakarta " + this.className);
                return new HttpJakartaMV(access, desc, mv, true);
            }
            if (TARGET_DOFILTER.equals(name)) {
                Logger.println("ASM", "jakarta-filter " + this.className);
                return new HttpJakartaMV(access, desc, mv, false);
            }
        }
        return mv;
    }
}

