/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.List;
import whatap.agent.ClassDesc;
import whatap.agent.asm.DebugMethodCV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.asm.weaving.WeavingHookSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class DebugMethodASM
extends IASM
implements Opcodes {
    private List<HookingSet> target = HookingSet.getHookingMethodSet(ConfHook.hook_method_debug_patterns);

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_method_debug_enabled) {
            return cv;
        }
        HookingSet hset = WeavingHookSet.service.get(className);
        if (hset != null) {
            return new DebugMethodCV(cv, hset, className);
        }
        for (int i = 0; i < this.target.size(); ++i) {
            HookingSet mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new DebugMethodCV(cv, mset, className);
        }
        return cv;
    }
}

