/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.Logger;
import whatap.agent.asm.DbcOpenMV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.StringUtil;

class DbcOpenCV
extends ClassVisitor
implements Opcodes {
    public String poolClassName;
    private HookingSet mset;

    public DbcOpenCV(ClassVisitor cv, HookingSet mset, String className) {
        super(IASM.API, cv);
        this.mset = mset;
        this.poolClassName = this.toPoolName(className);
    }

    private String toPoolName(String className) {
        String poolName = StringUtil.cutLastString(className, '/');
        return '@' + poolName;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || !this.mset.isA(name, desc)) {
            return mv;
        }
        if (AsmUtil.isSpecial(name)) {
            return mv;
        }
        Logger.println("BCI", "jdbc-con-open " + this.poolClassName);
        return new DbcOpenMV(access, desc, mv, this.poolClassName);
    }
}

