/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.app;

import java.util.ArrayList;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.app.AppCtxParserLoader;
import whatap.agent.app.IAppCtx;
import whatap.agent.app.PathDefault;
import whatap.agent.app.PathMatch;
import whatap.agent.app.PathPrefix;
import whatap.agent.data.DataPackSender;
import whatap.agent.trace.TraceContext;
import whatap.lang.pack.TagCountPack;
import whatap.lang.service.TxRecord;
import whatap.lang.value.ListValue;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppCtxStatCollector
extends Thread {
    private static AppCtxStatCollector instance;
    private Object lock = new Object();
    long workTime;
    static Configure conf;
    StringKeyLinkedMap<Perf> appCtxTable = this.resetTable();
    StringKeyLinkedMap<Perf> actTable = this.resetTable();
    long lasttime = DateUtil.nanoToMillis();
    private static int appCtxParserReset;
    private static String appCtxParserName;
    private static IAppCtx appCtxParser;

    public static synchronized AppCtxStatCollector getInstance() {
        if (instance == null) {
            instance = new AppCtxStatCollector();
            instance.setDaemon(true);
            instance.setName("AppCtxStatCollector");
            instance.start();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AppCtxStatCollector.update();
        while (true) {
            try {
                while (true) {
                    Object object = this.lock;
                    synchronized (object) {
                        try {
                            this.lock.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.process();
                }
            }
            catch (Throwable t) {
                Logger.println("AppCtxStat", t.toString());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(long time) {
        this.workTime = time;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    protected void process() {
        StringEnumer en;
        long now = DateUtil.nanoToMillis();
        double interval = (double)(now - this.lasttime) / 1000.0;
        this.lasttime = now;
        if (interval <= 1.0) {
            return;
        }
        ArrayList<String> pathList = new ArrayList<String>();
        if (AppCtxStatCollector.conf.app_context_path_set.size() > 0) {
            en = AppCtxStatCollector.conf.app_context_path_set.elements();
            while (en.hasMoreElements()) {
                pathList.add(en.nextString());
            }
        } else {
            if (this.appCtxTable.size() + this.actTable.size() == 0) {
                return;
            }
            en = this.appCtxTable.keys();
            while (en.hasMoreElements()) {
                pathList.add(en.nextString());
            }
            en = this.actTable.keys();
            while (en.hasMoreElements()) {
                String k = en.nextString();
                if (this.appCtxTable.containsKey(k)) continue;
                pathList.add(k);
            }
        }
        TagCountPack p = new TagCountPack();
        p.category = "app_context_stat";
        p.time = this.workTime;
        String name = appCtxParser.name();
        p.putTag("parser", name != null ? name : appCtxParser.getClass().getName());
        p.tags.put("!rectype", 2);
        ListValue idLv = p.fields.newList("@id");
        ListValue pathLv = p.fields.newList("path");
        ListValue actxLv = p.fields.newList("active_tx_count");
        ListValue act0Lv = p.fields.newList("active_tx_0");
        ListValue act3Lv = p.fields.newList("active_tx_3");
        ListValue act8Lv = p.fields.newList("active_tx_8");
        ListValue tpsLv = p.fields.newList("tps");
        ListValue cntLv = p.fields.newList("tx_count");
        ListValue errLv = p.fields.newList("tx_error");
        ListValue timLv = p.fields.newList("tx_time_sum");
        ListValue cntToleLv = p.fields.newList("tx_tolerated");
        ListValue cntSatisLv = p.fields.newList("tx_satisfied");
        for (String path : pathList) {
            idLv.add(HashUtil.hash(path));
            pathLv.add(path);
            Perf pf = this.actTable.get(path);
            if (pf == null) {
                pf = new Perf();
            }
            actxLv.add(pf.actx());
            act0Lv.add(pf.act0);
            act3Lv.add(pf.act3);
            act8Lv.add(pf.act8);
            Perf contextStat = this.appCtxTable.get(path);
            if (contextStat == null) {
                contextStat = new Perf();
            }
            tpsLv.add((float)((double)contextStat.cnt / interval));
            cntLv.add(contextStat.cnt);
            errLv.add(contextStat.err);
            timLv.add(contextStat.timeSum);
            cntToleLv.add(contextStat.tolerated);
            cntSatisLv.add(contextStat.satisfied);
        }
        this.actTable.clear();
        if (this.appCtxTable.size() > 0) {
            this.appCtxTable = this.resetTable();
        }
        DataPackSender.send(p);
    }

    private StringKeyLinkedMap<Perf> resetTable() {
        return new StringKeyLinkedMap<Perf>(191, 1.0f){

            @Override
            protected Perf create(String key) {
                return new Perf();
            }
        };
    }

    public void activeTx(String biz, int divAct) {
        if (biz != null) {
            Perf p = this.actTable.intern(biz);
            switch (divAct) {
                case 1: {
                    ++p.act3;
                    break;
                }
                case 2: {
                    ++p.act8;
                    break;
                }
                default: {
                    ++p.act0;
                }
            }
        }
    }

    public void endTx(String contextName, TxRecord tx) {
        if (contextName != null) {
            Perf p = this.appCtxTable.intern(contextName);
            ++p.cnt;
            p.timeSum += (long)tx.elapsed;
            if (tx.error != 0L) {
                ++p.err;
            } else {
                switch (tx.apdex) {
                    case 1: {
                        ++p.tolerated;
                        break;
                    }
                    case 2: {
                        ++p.satisfied;
                    }
                }
            }
        }
    }

    public static String getContextPath(int hash, String url, TraceContext ctx) {
        return appCtxParser.parse(hash, url, ctx);
    }

    public static synchronized void update() {
        block5: {
            try {
                if (!AppCtxStatCollector.conf.app_context_enabled) break block5;
                String newParser = StringUtil.trimEmpty(AppCtxStatCollector.conf.app_context_parser);
                int reset = AppCtxStatCollector.conf.app_context_parser_reset;
                if (!appCtxParserName.equals(newParser) || appCtxParserReset != reset) {
                    try {
                        appCtxParserReset = reset;
                        appCtxParserName = newParser;
                        appCtxParser = "default".equals(newParser) ? new PathDefault() : ("prefix".equals(newParser) ? new PathPrefix() : ("match".equals(newParser) ? new PathMatch() : AppCtxStatCollector.createDirect(newParser)));
                        Logger.green(appCtxParser.getClass().getName());
                    }
                    catch (Exception e) {
                        appCtxParser = new PathDefault();
                        Logger.red(e.toString());
                    }
                }
                appCtxParser.update();
            }
            catch (Throwable t) {
                Logger.red("AppCtxStatCollector: " + t.toString());
            }
        }
    }

    private static IAppCtx createDirect(String newParser) {
        IAppCtx app;
        String jar = AppCtxStatCollector.conf.app_context_parser_jarname;
        if (StringUtil.isEmpty(jar)) {
            return new PathDefault();
        }
        if (jar.indexOf("..") >= 0) {
            Logger.red("'app_context_parser_jarname' cannot contain '..'.");
            return new PathDefault();
        }
        if (jar.startsWith(".") || jar.indexOf("/") < 0) {
            jar = System.getProperty("whatap.home", ".") + "/appctx/" + jar;
        }
        if ((app = AppCtxParserLoader.load(jar, newParser)) == null) {
            app = new PathDefault();
        }
        return app;
    }

    static {
        conf = Configure.getInstance();
        appCtxParserName = "default";
        appCtxParser = new PathDefault();
    }

    static class Perf {
        int act0;
        int act3;
        int act8;
        int cnt;
        int err;
        long timeSum;
        int tolerated;
        int satisfied;

        Perf() {
        }

        int actx() {
            return this.act0 + this.act3 + this.act8;
        }
    }
}

