/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import whatap.lang.ref.BYTE;
import whatap.util.CompareUtil;
import whatap.util.FileUtil;
import whatap.util.HashUtil;
import whatap.util.StringUtil;

public class ParamSecurity {
    private static long lasttime = -1L;
    private static byte[] keyBytes = "WHATAP".getBytes();
    public static int keyHash = HashUtil.hash(keyBytes);
    private static byte[] threadKillBytes = "WHATAP".getBytes();
    public static int threadKillHash = HashUtil.hash(threadKillBytes);

    public static void reload() {
        String home = System.getProperty("whatap.home", ".");
        ParamSecurity.loadConf(home);
    }

    public static void loadConf(String home) {
        File securigtConf = new File(home, "security.conf");
        if (!securigtConf.exists()) {
            File originFile = new File(home, "paramkey.txt");
            if (originFile.exists()) {
                String origin;
                byte[] b = FileUtil.readAll(originFile);
                String string = origin = b == null ? "" : new String(b).trim();
                if (origin.length() == 0) {
                    origin = "WHATAP";
                }
                ParamSecurity.save(securigtConf, origin);
            } else {
                ParamSecurity.save(securigtConf, "WHATAP");
            }
        }
        if (securigtConf.lastModified() == lasttime) {
            return;
        }
        lasttime = securigtConf.lastModified();
        ParamSecurity.load(securigtConf);
    }

    private static void load(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Properties prop = new Properties();
            try {
                prop.load(in);
            }
            catch (Exception exception) {
                // empty catch block
            }
            keyBytes = ParamSecurity.toBytes(prop.getProperty("paramkey"), "WHATAP");
            keyHash = HashUtil.hash(keyBytes);
            threadKillBytes = ParamSecurity.toBytes(prop.getProperty("threadkill"), "WHATAP");
            threadKillHash = HashUtil.hash(threadKillBytes);
        }
        catch (Exception e) {
            FileUtil.close(in);
        }
    }

    private static byte[] toBytes(String val, String def) {
        return !StringUtil.isEmpty(val = StringUtil.trim(val)) ? val.getBytes() : def.getBytes();
    }

    private static void save(File securigtConf, String password) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(securigtConf);
            Properties prop = new Properties();
            prop.put("paramkey", password);
            prop.put("threadkill", password);
            prop.store(out, "created from paramkey.txt");
        }
        catch (Exception e) {
            FileUtil.close(out);
        }
    }

    public static boolean isSafeThreadKill(String userInputKey) {
        if (StringUtil.isEmpty(userInputKey = StringUtil.trim(userInputKey))) {
            return false;
        }
        try {
            return CompareUtil.equals(threadKillBytes, userInputKey.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static byte[] encrypt(byte[] b, BYTE crc) {
        int i = 0;
        int j = 0;
        while (i < b.length) {
            crc.value = (byte)(crc.value ^ b[i]);
            int n = i++;
            b[n] = (byte)(b[n] ^ keyBytes[j]);
            j = (j + 1) % keyBytes.length;
        }
        return b;
    }
}

