/*
 * Decompiled with CFR 0.152.
 */
package whatap;

import whatap.agent.api.trace.Request;
import whatap.agent.api.trace.Response;
import whatap.agent.api.trace.TxTrace;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.lang.step.MessageStep;
import whatap.util.HashUtil;

public class TRACE {
    public static Object get() {
        return TraceContextManager.getLocalContext();
    }

    public static TrKey getTrKey() {
        TrKey trid = new TrKey();
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            trid.mtid = ctx.mtid;
            trid.mdepth = ctx.mdepth;
            trid.txid = ctx.txid;
        }
        return trid;
    }

    public static Object jump() {
        TraceContext ctx = TraceContextManager.getLocalContext();
        TraceContextManager.detach();
        return ctx;
    }

    public static void set(Object ctxObj) {
        TraceContext ctx = (TraceContext)ctxObj;
        ctx.thread = Thread.currentThread();
        TraceContextManager.attach(ctx);
    }

    public static void profile(String title, String message, int elapsed, int value) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = HashUtil.hash(title);
            DataTextAgent.MESSAGE.add(step.hash, title);
            step.time = elapsed;
            step.value = value;
            step.desc = message;
            ctx.profile.add(step);
        }
    }

    public static void profile(Object ctxObj, String title, String message, int elapsed, int value) {
        if (ctxObj != null) {
            TraceContext ctx = (TraceContext)ctxObj;
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = HashUtil.hash(title);
            DataTextAgent.MESSAGE.add(step.hash, title);
            step.time = elapsed;
            step.value = value;
            step.desc = message;
            ctx.profile.add(step);
        }
    }

    public static Object start(Request req, Response res) {
        return TxTrace.startHttpTx(req, res);
    }

    public static void end(Object ctx, Throwable thr) {
        if (ctx instanceof TraceContext) {
            TxTrace.endHttpTx((TraceContext)ctx, thr);
        }
    }

    public static class TrKey {
        public long mtid;
        public int mdepth;
        public long txid;
    }
}

