/*
 * Decompiled with CFR 0.152.
 */
package whatap.v1;

import java.lang.ref.WeakReference;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import whatap.agent.api.trace.TxTrace;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.TraceHttpc;
import whatap.agent.trace.TraceMain;
import whatap.lang.step.MessageStep;
import whatap.util.HashUtil;
import whatap.v1.TraceCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trace {
    public static Runnable run(final TraceCtx ctx, final Runnable f) {
        if (ctx == null) {
            return f;
        }
        return new Runnable(){

            public void run() {
                Trace.attach(ctx);
                try {
                    f.run();
                }
                finally {
                    if (ctx.ctx.thread != Thread.currentThread()) {
                        Trace.detach();
                    }
                }
            }
        };
    }

    public static Runnable run(Runnable f) {
        return Trace.run(Trace.context(), f);
    }

    public static <T, R> Function<? super T, R> func(final TraceCtx ctx, final Function<? super T, R> org) {
        if (ctx == null) {
            return org;
        }
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                Trace.attach(ctx);
                try {
                    Object r = org.apply(t);
                    return r;
                }
                finally {
                    if (ctx.ctx.thread != Thread.currentThread()) {
                        Trace.detach();
                    }
                }
            }
        };
    }

    public static <T, R> Function<? super T, R> func(Function<? super T, R> org) {
        return Trace.func(Trace.context(), org);
    }

    public static TraceCtx detach(Object key) {
        if (key == null) {
            return null;
        }
        WeakReference<TraceContext> ref = TxTrace.txTraceMap.remove(key);
        if (ref == null) {
            return null;
        }
        TraceContext org = (TraceContext)ref.get();
        if (org == null) {
            return null;
        }
        TraceCtx ctx = new TraceCtx();
        ctx.ctx = org;
        return ctx;
    }

    public static void link(Object key) {
        if (key == null) {
            return;
        }
        WeakReference<TraceContext> ref = TxTrace.txTraceMap.remove(key);
        if (ref != null) {
            TraceContextManager.attach((TraceContext)ref.get());
        }
    }

    public static void attach(Object key, TraceCtx ctx) {
        if (key != null && ctx != null) {
            TxTrace.txTraceMap.put(key, new WeakReference<TraceContext>(ctx.ctx));
        }
    }

    public static long txid() {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            return ctx.txid;
        }
        return 0L;
    }

    public static long mtid() {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            return ctx.mtid;
        }
        return 0L;
    }

    public static TraceCtx context() {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            TraceHttpc.setRatedMtraceKey(ctx);
            TraceCtx tctx = new TraceCtx();
            tctx.ctx = ctx;
            return tctx;
        }
        return null;
    }

    public static TraceCtx context(long ctxId) {
        TraceContext ctx = TraceContextManager.getContext(ctxId);
        if (ctx != null) {
            TraceHttpc.setRatedMtraceKey(ctx);
            TraceCtx tctx = new TraceCtx();
            tctx.ctx = ctx;
            return tctx;
        }
        return null;
    }

    public static void detach() {
        TraceContextManager.detach();
    }

    public static void attach(TraceCtx tctx) {
        if (tctx != null) {
            TraceContextManager.attach(tctx.ctx);
        }
    }

    public static void step(String title, String message, int elapsed, int value) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = HashUtil.hash(title);
            DataTextAgent.MESSAGE.add(step.hash, title);
            step.time = elapsed;
            step.value = value;
            step.desc = message;
            ctx.profile.add(step);
        }
    }

    public static void step(TraceCtx tctx, String title, String message, int elapsed, int value) {
        if (tctx != null) {
            TraceContext ctx = tctx.ctx;
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = HashUtil.hash(title);
            DataTextAgent.MESSAGE.add(step.hash, title);
            step.time = elapsed;
            step.value = value;
            step.desc = message;
            ctx.profile.add(step);
        }
    }

    public static TraceCtx start(String name) {
        TraceContext ctx = TxTrace.startTx(name);
        if (ctx == null) {
            return null;
        }
        TraceCtx trx = new TraceCtx();
        trx.ctx = ctx;
        return trx;
    }

    public static void end(TraceCtx tctx, Throwable thr) {
        if (tctx != null) {
            TxTrace.endTx(tctx.ctx, thr);
        }
    }

    public static <T> CompletableFuture<T> complete(CompletableFuture<T> c) {
        if (c == null) {
            return c;
        }
        final TraceContext ctx1 = TraceContextManager.getLocalContext();
        if (ctx1 == null) {
            return c;
        }
        TraceContextManager.detach();
        ctx1.closed = true;
        BiConsumer b = new BiConsumer<T, Throwable>(){

            @Override
            public void accept(T t, Throwable thr) {
                ctx1.closed = false;
                TxTrace.endTx(ctx1, thr);
            }
        };
        return c.whenComplete(b);
    }

    public static void exception(Throwable thr) {
        TraceMain.exception(thr);
    }
}

