/*
 * Decompiled with CFR 0.152.
 */
package whatap.v1;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.meter.MeterSQL;
import whatap.agent.data.DataTextAgent;
import whatap.agent.stat.ErrorArg;
import whatap.agent.stat.StatError;
import whatap.agent.stat.StatSql;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.sql.TraceSQL;
import whatap.lang.ref.BYTE;
import whatap.lang.step.SqlStepX;
import whatap.notice.WHATAP_ERROR;
import whatap.util.HashUtil;
import whatap.v1.SqlCtx;
import whatap.v1.TraceCtx;

public class Sql {
    private static Configure conf = Configure.getInstance();
    private static int logcount = 0;

    public static SqlCtx start(String dbc, String sql) {
        return Sql.start(dbc, sql, null);
    }

    public static SqlCtx start(String dbhost, String sql, String param) {
        if (!Sql.conf.sql_enabled) {
            return null;
        }
        try {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null || sql == null) {
                return null;
            }
            SqlStepX step = new SqlStepX();
            if (dbhost != null) {
                int dbc_hash = HashUtil.hash(dbhost);
                DataTextAgent.dbc(dbc_hash, dbhost);
                step.dbc = dbc_hash;
            }
            int sql_hash = HashUtil.hash(sql);
            DataTextAgent.SQL.add(sql_hash, sql);
            step.hash = sql_hash;
            step.xtype = (byte)48;
            if (ConfTrace.trace_sql_param_enabled && param != null) {
                BYTE crc = new BYTE();
                step.p1 = TraceSQL.toParamBytes(param, crc);
                step.pcrc = crc.value;
            }
            step.start_time = ctx.getElapsedTime();
            ctx.profile.push(step);
            ctx.sql = step;
            ctx.sqlText = sql;
            SqlCtx sctx = new SqlCtx();
            sctx.ctx = ctx;
            sctx.step = step;
            return sctx;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void end(SqlCtx sctx, Throwable thr) {
        block6: {
            if (sctx == null) {
                return;
            }
            try {
                TraceContext ctx = sctx.ctx;
                SqlStepX step = sctx.step;
                step.elapsed = ctx.getElapsedTime() - step.start_time;
                if (thr != null) {
                    ErrorArg arg = new ErrorArg();
                    arg.exception = thr;
                    arg.message = thr.getMessage();
                    arg.setTraceCtx(ctx);
                    arg.appendSql(step.hash);
                    step.error = StatError.getInstance().addError(arg);
                    ctx.handleSqlErrorStack(thr);
                } else if (step.elapsed > ConfTrace.trace_error_sql_time_max) {
                    ErrorArg arg = new ErrorArg();
                    arg.exception = WHATAP_ERROR.slow_sql;
                    arg.message = WHATAP_ERROR.slow_sql.getMessage();
                    arg.setTraceCtx(ctx);
                    arg.appendSql(step.hash);
                    step.error = StatError.getInstance().addError(arg);
                }
                MeterSQL.getInstance().add(step.dbc, step.elapsed, step.error != 0L);
                StatSql.getInstance().addSqlTime(ctx.service_hash, step.dbc, step.hash, step.elapsed, step.error != 0L);
                ctx.profile.pop(step);
                ctx.sql = null;
                ctx.sqlText = null;
                ++ctx.sql_count;
                ctx.sql_time += step.elapsed;
            }
            catch (Throwable t) {
                if (logcount >= 5) break block6;
                ++logcount;
                Logger.println("SQL " + t, t);
            }
        }
    }

    public static void trace(TraceCtx ctx, String dbhost, String sql, String param, int elapsed, Throwable thr) {
        if (!Sql.conf.sql_enabled) {
            return;
        }
        if (ctx == null || sql == null) {
            return;
        }
        Sql.doTrace(ctx.ctx, dbhost, sql, param, elapsed, thr);
    }

    public static void trace(String dbhost, String sql, String param, int elapsed, Throwable thr) {
        if (!Sql.conf.sql_enabled) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null || sql == null) {
            return;
        }
        Sql.doTrace(ctx, dbhost, sql, param, elapsed, thr);
    }

    protected static void doTrace(TraceContext ctx, String dbhost, String sql, String param, int elapsed, Throwable thr) {
        block7: {
            try {
                ErrorArg arg;
                SqlStepX step = new SqlStepX();
                if (dbhost != null) {
                    int dbc_hash = HashUtil.hash(dbhost);
                    DataTextAgent.dbc(dbc_hash, dbhost);
                    step.dbc = dbc_hash;
                }
                int sql_hash = HashUtil.hash(sql);
                DataTextAgent.SQL.add(sql_hash, sql);
                step.hash = sql_hash;
                step.xtype = (byte)48;
                if (ConfTrace.trace_sql_param_enabled && param != null) {
                    BYTE crc = new BYTE();
                    step.p1 = TraceSQL.toParamBytes(param, crc);
                    step.pcrc = crc.value;
                }
                step.start_time = ctx.getElapsedTime();
                step.elapsed = elapsed;
                if (thr != null) {
                    arg = new ErrorArg();
                    arg.exception = thr;
                    arg.message = thr.getMessage();
                    arg.setTraceCtx(ctx);
                    arg.appendSql(step.hash);
                    step.error = StatError.getInstance().addError(arg);
                    ctx.handleSqlErrorStack(thr);
                } else if (step.elapsed > ConfTrace.trace_error_sql_time_max) {
                    arg = new ErrorArg();
                    arg.exception = WHATAP_ERROR.slow_sql;
                    arg.message = WHATAP_ERROR.slow_sql.getMessage();
                    arg.setTraceCtx(ctx);
                    arg.appendSql(step.hash);
                    step.error = StatError.getInstance().addError(arg);
                }
                MeterSQL.getInstance().add(step.dbc, step.elapsed, step.error != 0L);
                StatSql.getInstance().addSqlTime(ctx.service_hash, step.dbc, step.hash, step.elapsed, step.error != 0L);
                ++ctx.sql_count;
                ctx.sql_time += step.elapsed;
                ctx.profile.add(step);
            }
            catch (Throwable t) {
                if (logcount >= 5) break block7;
                ++logcount;
                Logger.println("SQL " + t, t);
            }
        }
    }
}

