/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopN<V extends Comparable<V>> {
    private LinkedList<V> list = new LinkedList();
    private int topN;
    private byte direction = 1;

    public TopN(int max) {
        this.topN = max;
    }

    public TopN(int max, byte direction) {
        this.topN = max;
        this.direction = direction;
    }

    public void add(V k) {
        block17: {
            if (this.list.size() == 0) {
                this.list.add(k);
                return;
            }
            int high = this.list.size() - 1;
            int low = 0;
            do {
                int mid;
                Comparable v;
                int compare;
                if ((compare = (v = (Comparable)this.list.get(mid = (high + low) / 2)).compareTo(k)) == 0) {
                    this.list.add(mid, k);
                } else {
                    if (compare < 0) {
                        low = mid;
                    } else {
                        high = mid;
                    }
                    if (high != low) continue;
                    if (((Comparable)this.list.get(high)).compareTo(k) > 0) {
                        this.list.add(high, k);
                    } else {
                        this.list.add(high + 1, k);
                    }
                }
                break block17;
            } while (high - low != 1);
            if (((Comparable)this.list.get(low)).compareTo(k) > 0) {
                this.list.add(low, k);
            } else if (((Comparable)this.list.get(high)).compareTo(k) < 0) {
                this.list.add(high + 1, k);
            } else {
                this.list.add(high, k);
            }
        }
        while (this.list.size() > this.topN) {
            switch (this.direction) {
                case 1: {
                    this.list.removeLast();
                    break;
                }
                case 2: {
                    this.list.removeFirst();
                }
            }
        }
    }

    public List<V> getList() {
        ArrayList<V> out = new ArrayList<V>();
        if (this.direction == 2) {
            for (int i = this.list.size() - 1; i >= 0; --i) {
                out.add(this.list.get(i));
            }
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                out.add(this.list.get(i));
            }
        }
        return out;
    }

    public int size() {
        return this.list.size();
    }

    public static void main(String[] args) {
        long stime = System.currentTimeMillis();
        TopN<Integer> list = new TopN<Integer>(1000, 2);
        Random r = new Random();
        r.setSeed(System.currentTimeMillis());
        for (int i = 0; i < 100000; ++i) {
            list.add(new Integer(r.nextInt(100000)));
        }
        System.out.println(list.size() + " : " + list.getList());
        long etime = System.currentTimeMillis();
        System.out.println(etime - stime + " ms");
    }
}

