/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import com.sun.management.OperatingSystemMXBean;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import whatap.util.FileUtil;
import whatap.util.IPUtil;
import whatap.util.StringUtil;
import whatap.util.SystemUtil;

public class SysJMX {
    private static ThreadMXBean threadmx;
    private static java.lang.management.OperatingSystemMXBean osmx;
    private static RuntimeMXBean rtmx;
    private static boolean isSunProCpu;
    private static boolean sunThreadMX;
    private static boolean isSunMem;
    private static int pid;
    private static String hostname;
    private static long stime;

    public static long getCurrentThreadCPU() {
        if (threadmx == null) {
            return 0L;
        }
        try {
            return threadmx.getCurrentThreadCpuTime() / 1000000L;
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static long getCurrentThreadCPUnano() {
        if (threadmx == null) {
            return 0L;
        }
        try {
            return threadmx.getCurrentThreadCpuTime();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static long getCurrentThreadAllocBytes() {
        if (!sunThreadMX) {
            return 0L;
        }
        try {
            return ((com.sun.management.ThreadMXBean)threadmx).getThreadAllocatedBytes(Thread.currentThread().getId());
        }
        catch (Throwable t) {
            sunThreadMX = false;
            return 0L;
        }
    }

    public static long getThreadAllocBytes(long id) {
        if (!sunThreadMX) {
            return 0L;
        }
        try {
            return ((com.sun.management.ThreadMXBean)threadmx).getThreadAllocatedBytes(id);
        }
        catch (Throwable t) {
            sunThreadMX = false;
            return 0L;
        }
    }

    public static long getThreadCPU(long id) {
        if (threadmx == null) {
            return 0L;
        }
        try {
            return threadmx.getThreadCpuTime(id) / 1000000L;
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static long getCurrentProcGcTime() {
        if (threadmx == null) {
            return 0L;
        }
        try {
            List<GarbageCollectorMXBean> gclist = ManagementFactory.getGarbageCollectorMXBeans();
            long gctime = 0L;
            for (int i = 0; i < gclist.size(); ++i) {
                GarbageCollectorMXBean mxs = gclist.get(i);
                gctime += mxs.getCollectionTime();
            }
            return gctime;
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static long[] getCurrentProcGcInfo() {
        long[] gc = new long[2];
        if (threadmx == null) {
            return gc;
        }
        try {
            List<GarbageCollectorMXBean> gclist = ManagementFactory.getGarbageCollectorMXBeans();
            for (int i = 0; i < gclist.size(); ++i) {
                GarbageCollectorMXBean mxs = gclist.get(i);
                gc[0] = gc[0] + mxs.getCollectionCount();
                gc[1] = gc[1] + mxs.getCollectionTime();
            }
            return gc;
        }
        catch (Throwable t) {
            return gc;
        }
    }

    public static float getSystemLoad() {
        if (osmx != null) {
            try {
                return (float)osmx.getSystemLoadAverage() / (float)osmx.getAvailableProcessors();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public static boolean isProcessCPU() {
        return isSunProCpu;
    }

    public static long getProcessCPU() {
        if (!isSunProCpu) {
            return 0L;
        }
        try {
            return ((OperatingSystemMXBean)osmx).getProcessCpuTime() / 1000000L;
        }
        catch (Throwable t) {
            isSunProCpu = false;
            return 0L;
        }
    }

    public static long getProcessCPUnano() {
        if (!isSunProCpu) {
            return 0L;
        }
        try {
            return ((OperatingSystemMXBean)osmx).getProcessCpuTime();
        }
        catch (Throwable t) {
            isSunProCpu = false;
            return 0L;
        }
    }

    public static int getProcessPID() {
        if (pid >= -1) {
            return pid;
        }
        try {
            RuntimeMXBean o = ManagementFactory.getRuntimeMXBean();
            String nm = o.getName();
            int x = nm.indexOf("@");
            pid = x > 0 ? Integer.parseInt(nm.substring(0, x)) : -1;
        }
        catch (Exception e) {
            pid = -1;
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostName() {
        if (hostname != null) {
            return hostname;
        }
        hostname = System.getProperty("hostname");
        if (StringUtil.isNotEmpty(hostname)) {
            return hostname;
        }
        try {
            RuntimeMXBean o = ManagementFactory.getRuntimeMXBean();
            String nm = o.getName();
            int x = nm.indexOf("@");
            hostname = nm.substring(x + 1);
            if (StringUtil.isNotEmpty(hostname)) {
                return hostname;
            }
        }
        catch (Exception o) {
            // empty catch block
        }
        if (SystemUtil.IS_LINUX) {
            String string;
            InputStream is = null;
            OutputStream os = null;
            InputStream es = null;
            try {
                Process process = Runtime.getRuntime().exec("hostname");
                is = process.getInputStream();
                os = process.getOutputStream();
                es = process.getErrorStream();
                byte[] isBytes = FileUtil.readAll(is);
                hostname = new String(isBytes);
                if (StringUtil.isNotEmpty(hostname)) {
                    hostname = hostname.replaceAll("\n", "");
                    hostname = hostname.replaceAll("\r", "");
                }
                string = hostname;
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                FileUtil.close(os);
                FileUtil.close(es);
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                FileUtil.close(os);
                FileUtil.close(es);
                throw throwable;
            }
            FileUtil.close(is);
            FileUtil.close(os);
            FileUtil.close(es);
            return string;
        }
        hostname = "unknown";
        return hostname;
    }

    public static String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    public static long getThreadCpuTime(long threadId) {
        if (threadmx == null) {
            return 0L;
        }
        return threadmx.getThreadCpuTime(threadId) / 1000000L;
    }

    public static long getTotalPhysicalMemorySize() {
        if (!isSunMem) {
            return 0L;
        }
        try {
            return ((OperatingSystemMXBean)osmx).getTotalPhysicalMemorySize();
        }
        catch (Throwable t) {
            isSunMem = false;
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserName() {
        String username = SystemUtil.USER_NAME;
        if (StringUtil.isNotEmpty(username)) {
            return username;
        }
        username = System.getenv("USERNAME");
        if (StringUtil.isNotEmpty(username)) {
            return username;
        }
        InputStream is = null;
        OutputStream os = null;
        InputStream es = null;
        try {
            Process process = Runtime.getRuntime().exec("whoami");
            is = process.getInputStream();
            os = process.getOutputStream();
            es = process.getErrorStream();
            byte[] isBytes = FileUtil.readAll(is);
            username = new String(isBytes);
        }
        catch (Throwable th) {
            try {
                th.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                FileUtil.close(os);
                FileUtil.close(es);
                throw throwable;
            }
            FileUtil.close(is);
            FileUtil.close(os);
            FileUtil.close(es);
        }
        FileUtil.close(is);
        FileUtil.close(os);
        FileUtil.close(es);
        return username;
    }

    public static String getUsingJava() {
        return SystemUtil.JAVA_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalAddr(String host, int port) {
        Socket conn = new Socket();
        try {
            conn.connect(new InetSocketAddress(host, port), 3);
            InetAddress addr = conn.getLocalAddress();
            String string = IPUtil.toString(addr.getAddress());
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            FileUtil.close(conn);
        }
    }

    public static long getUptime() {
        RuntimeMXBean o = ManagementFactory.getRuntimeMXBean();
        return o.getUptime();
    }

    public static long getStartTime() {
        if (stime > 0L) {
            return stime;
        }
        RuntimeMXBean o = ManagementFactory.getRuntimeMXBean();
        stime = o.getStartTime();
        return stime;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(SysJMX.getUptime());
    }

    static {
        isSunProCpu = true;
        sunThreadMX = false;
        isSunMem = true;
        try {
            threadmx = ManagementFactory.getThreadMXBean();
            osmx = ManagementFactory.getOperatingSystemMXBean();
            rtmx = ManagementFactory.getRuntimeMXBean();
            sunThreadMX = threadmx.getClass().getName().indexOf("sun") >= 0;
        }
        catch (Throwable t) {
            threadmx = null;
            osmx = null;
            rtmx = null;
            sunThreadMX = false;
        }
        try {
            if (osmx != null) {
                Class<?> c = osmx.getClass();
                isSunProCpu = c.getMethod("getProcessCpuTime", new Class[0]) != null;
                isSunMem = isSunProCpu;
            } else {
                isSunProCpu = false;
                isSunMem = false;
            }
        }
        catch (Throwable t) {
            isSunProCpu = false;
            isSunMem = false;
        }
        pid = -2;
        hostname = null;
        stime = 0L;
    }
}

