/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.util.CompareUtil;
import whatap.util.IntEnumer;
import whatap.util.StringEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringIntLinkedMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private StringIntLinkedEntry[] table;
    private StringIntLinkedEntry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;
    private int max;

    public StringIntLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new StringIntLinkedEntry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new StringIntLinkedEntry(null, 0, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public StringIntLinkedMap() {
        this(101, 0.75f);
    }

    public StringIntLinkedMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public int size() {
        return this.count;
    }

    public String[] keyArray() {
        String[] _keys = new String[this.size()];
        StringEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextString();
        }
        return _keys;
    }

    public synchronized StringEnumer keys() {
        return new Enumer(1);
    }

    public synchronized IntEnumer values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<StringIntLinkedEntry> entries() {
        return new Enumer(3);
    }

    public synchronized boolean containsValue(int value) {
        StringIntLinkedEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            StringIntLinkedEntry e = tab[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(String key) {
        StringIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized int get(String key) {
        if (key == null) {
            return this.NONE;
        }
        StringIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized int getFirsValue() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.header.link_next.value;
    }

    public synchronized String getFirsKey() {
        if (this.isEmpty()) {
            return null;
        }
        return this.header.link_next.key;
    }

    public synchronized int getLastValue() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.header.link_prev.value;
    }

    private int hash(String key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        StringIntLinkedEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        StringIntLinkedEntry[] newMap = new StringIntLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            StringIntLinkedEntry old = oldMap[i];
            while (old != null) {
                StringIntLinkedEntry e = old;
                old = old.next;
                String key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public StringIntLinkedMap setMax(int max) {
        this.max = max;
        return this;
    }

    public int put(String key, int value) {
        return this._put(key, value, 4);
    }

    public int putLast(String key, int value) {
        return this._put(key, value, 2);
    }

    public int putFirst(String key, int value) {
        return this._put(key, value, 1);
    }

    public int add(String key, int value) {
        return this._add(key, value, 4);
    }

    public int addLast(String key, int value) {
        return this._add(key, value, 2);
    }

    public int addFirst(String key, int value) {
        return this._add(key, value, 1);
    }

    private synchronized int _put(String key, int value, int m) {
        if (key == null) {
            return this.NONE;
        }
        StringIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                int old = e.value;
                e.value = value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new StringIntLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    public void overflowed(String key, long value) {
    }

    private synchronized int _add(String key, int value, int m) {
        if (key == null) {
            return this.NONE;
        }
        StringIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                int old = e.value;
                e.value += value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new StringIntLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    public synchronized int remove(String key) {
        if (key == null) {
            return this.NONE;
        }
        StringIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringIntLinkedEntry e = tab[index];
        StringIntLinkedEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                int oldValue = e.value;
                e.value = 0;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized int removeFirst() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized int removeLast() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.max > 0 && this.max <= this.count;
    }

    public synchronized void clear() {
        StringIntLinkedEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringIntLinkedEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            StringIntLinkedEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringIntLinkedEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            StringIntLinkedEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(StringIntLinkedEntry link_prev, StringIntLinkedEntry link_next, StringIntLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(StringIntLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public synchronized void sort(Comparator<StringIntLinkedEntry> c) {
        ArrayList<StringIntLinkedEntry> list = new ArrayList<StringIntLinkedEntry>(this.size());
        Enumeration<StringIntLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            StringIntLinkedEntry e = (StringIntLinkedEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    private class Enumer
    implements Enumeration,
    StringEnumer,
    IntEnumer {
        byte type;
        StringIntLinkedEntry entry;

        Enumer(byte type) {
            this.entry = ((StringIntLinkedMap)StringIntLinkedMap.this).header.link_next;
            this.type = type;
        }

        public boolean hasMoreElements() {
            return StringIntLinkedMap.this.header != this.entry && this.entry != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                StringIntLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                    case 2: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        public int nextInt() {
            if (this.hasMoreElements()) {
                StringIntLinkedEntry e = this.entry;
                this.entry = e.link_next;
                return e.value;
            }
            throw new NoSuchElementException("no more next");
        }

        public String nextString() {
            if (this.hasMoreElements()) {
                StringIntLinkedEntry e = this.entry;
                this.entry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    public static class StringIntLinkedEntry {
        String key;
        int value;
        StringIntLinkedEntry next;
        StringIntLinkedEntry link_next;
        StringIntLinkedEntry link_prev;

        protected StringIntLinkedEntry(String key, int value, StringIntLinkedEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new StringIntLinkedEntry(this.key, this.value, this.next == null ? null : (StringIntLinkedEntry)this.next.clone());
        }

        public String getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringIntLinkedEntry)) {
                return false;
            }
            StringIntLinkedEntry e = (StringIntLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

