/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.util.IntEnumer;
import whatap.util.StringEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHashCacheMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private StringHashCacheEntry[] table;
    private StringHashCacheEntry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int max;

    public StringHashCacheMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new StringHashCacheEntry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new StringHashCacheEntry(null, 0, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public StringHashCacheMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public String[] keyArray() {
        String[] _keys = new String[this.size()];
        StringEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextString();
        }
        return _keys;
    }

    public synchronized StringEnumer keys() {
        return new Enumer(1);
    }

    public synchronized IntEnumer values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<StringHashCacheEntry> myEntries() {
        return new Enumer(3);
    }

    public synchronized boolean containsValue(int value) {
        StringHashCacheEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            StringHashCacheEntry e = tab[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(String key) {
        StringHashCacheEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringHashCacheEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized int get(String key) {
        if (key == null) {
            return 0;
        }
        StringHashCacheEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringHashCacheEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    public synchronized int getFirsValue() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.header.link_next.value;
    }

    public synchronized int getLastValue() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.header.link_prev.value;
    }

    private int hash(String key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        StringHashCacheEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        StringHashCacheEntry[] newMap = new StringHashCacheEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            StringHashCacheEntry old = oldMap[i];
            while (old != null) {
                StringHashCacheEntry e = old;
                old = old.next;
                String key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public StringHashCacheMap setMax(int max) {
        this.max = max;
        return this;
    }

    public int put(String key, int value) {
        return this._put(key, value, 4);
    }

    public int putLast(String key, int value) {
        return this._put(key, value, 2);
    }

    public int putFirst(String key, int value) {
        return this._put(key, value, 1);
    }

    private synchronized int _put(String key, int value, int m) {
        if (key == null) {
            return 0;
        }
        StringHashCacheEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringHashCacheEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                int old = e.value;
                e.value = value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new StringHashCacheEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return 0;
    }

    protected void overflowed(String key, int value) {
    }

    public synchronized int remove(String key) {
        if (key == null) {
            return 0;
        }
        StringHashCacheEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringHashCacheEntry e = tab[index];
        StringHashCacheEntry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                int oldValue = e.value;
                e.value = 0;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return 0;
    }

    public synchronized int removeFirst() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized int removeLast() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        StringHashCacheEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringHashCacheEntry> it = this.myEntries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            StringHashCacheEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringHashCacheEntry> it = this.myEntries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            StringHashCacheEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(StringHashCacheEntry link_prev, StringHashCacheEntry link_next, StringHashCacheEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(StringHashCacheEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public static void main(String[] args) {
    }

    private static void print(Object e) {
        System.out.println(e);
    }

    private class Enumer
    implements Enumeration,
    StringEnumer,
    IntEnumer {
        byte type;
        StringHashCacheEntry myEntry;

        Enumer(byte type) {
            this.myEntry = ((StringHashCacheMap)StringHashCacheMap.this).header.link_next;
            this.type = type;
        }

        public boolean hasMoreElements() {
            return StringHashCacheMap.this.header != this.myEntry && this.myEntry != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                StringHashCacheEntry e = this.myEntry;
                this.myEntry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                    case 2: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        public int nextInt() {
            if (this.hasMoreElements()) {
                StringHashCacheEntry e = this.myEntry;
                this.myEntry = e.link_next;
                return e.value;
            }
            throw new NoSuchElementException("no more next");
        }

        public String nextString() {
            if (this.hasMoreElements()) {
                StringHashCacheEntry e = this.myEntry;
                this.myEntry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    public static class StringHashCacheEntry {
        String key;
        int value;
        StringHashCacheEntry next;
        StringHashCacheEntry link_next;
        StringHashCacheEntry link_prev;

        protected StringHashCacheEntry(String key, int value, StringHashCacheEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new StringHashCacheEntry(this.key, this.value, this.next == null ? null : (StringHashCacheEntry)this.next.clone());
        }

        public String getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringHashCacheEntry)) {
                return false;
            }
            StringHashCacheEntry e = (StringHashCacheEntry)o;
            return e.key == this.key && e.value == this.value;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

