/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import whatap.util.CastUtil;
import whatap.util.CipherAgent;
import whatap.util.FileUtil;
import whatap.util.IntLinkedSet;
import whatap.util.LinkedMap;
import whatap.util.StringLinkedSet;
import whatap.util.StringSet;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyX {
    private final CipherAgent cipher;
    protected LinkedMap<String, String> property = new LinkedMap();

    public PropertyX() {
        this.cipher = new CipherAgent(null);
    }

    public PropertyX(String masterkey) {
        this.cipher = new CipherAgent(masterkey);
    }

    public String setProperty(String key, String value) {
        return this.property.put(key, value);
    }

    public void removeProperty(String key) {
        this.property.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyX load(File file) {
        if (!file.canRead()) {
            return this;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            this.load(reader);
        }
        catch (Exception exception) {
            FileUtil.close(reader);
        }
        catch (Throwable throwable) {
            FileUtil.close(reader);
            throw throwable;
        }
        FileUtil.close(reader);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(file);
            this.save(pw);
        }
        catch (Exception exception) {
            FileUtil.close(pw);
        }
        catch (Throwable throwable) {
            FileUtil.close(pw);
            throw throwable;
        }
        FileUtil.close(pw);
    }

    public void save(PrintWriter pw) {
        try {
            Enumeration<String> en = this.property.keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String value = this.property.get(key);
                if (value.indexOf("\n") > 0) {
                    pw.println(key + "='''");
                    pw.println(value);
                    pw.println("'''");
                    continue;
                }
                pw.println(key + "=" + value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized PropertyX load(Reader fileReader) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(fileReader);
            StringBuffer buff = new StringBuffer();
            boolean backslash = false;
            while ((line = StringUtil.trim(reader.readLine())) != null) {
                if (!backslash) {
                    if (buff.length() > 0) {
                        buff = this.putAndClear(buff);
                    }
                    if (this.isComment(line)) continue;
                    if (line.endsWith("'''")) {
                        buff.append(line.substring(0, line.length() - 3));
                        line = StringUtil.trimRight(reader.readLine());
                        while (line != null && !line.endsWith("'''")) {
                            buff.append(line).append("\n");
                            line = StringUtil.trimRight(reader.readLine());
                        }
                        if (line != null) {
                            buff.append(line.substring(0, line.length() - 3));
                        }
                        buff = this.putAndClear(buff);
                        continue;
                    }
                }
                if (this.isBackslash(line)) {
                    backslash = true;
                    if (buff.length() > 0) {
                        buff.append(' ');
                    }
                    buff.append(line.substring(0, line.length() - 1));
                    continue;
                }
                backslash = false;
                if (buff.length() > 0) {
                    buff.append(' ');
                }
                buff.append(line);
            }
            buff = this.putAndClear(buff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    private boolean isComment(String line) {
        return line.startsWith("#");
    }

    private boolean isBackslash(String line) {
        return line.endsWith("\\");
    }

    private StringBuffer putAndClear(StringBuffer buff) {
        if (buff.length() > 0) {
            int x = buff.indexOf("=");
            if (x > 0) {
                String key = buff.substring(0, x).trim();
                String value = buff.substring(x + 1).trim();
                this.property.put(key, value);
            }
            return new StringBuffer();
        }
        return buff;
    }

    public String getProperty(String key) {
        return this.property.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public boolean getBoolean(String key, boolean defValue) {
        String value = this.getProperty(key);
        return value != null ? CastUtil.cboolean(value) : defValue;
    }

    public int getInt(String key) {
        return CastUtil.cint(this.getProperty(key));
    }

    public int getInt(String key, int defValue) {
        String value = this.getProperty(key);
        return value != null ? CastUtil.cint(value) : defValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration<String> en = this.property.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            String value = this.getProperty(key);
            if (value.indexOf("\n") < 0) {
                sb.append(key).append("=").append(value).append("\n");
                continue;
            }
            sb.append(key).append("=").append("'''").append("\n");
            sb.append(value).append("\n");
            sb.append("'''\n");
        }
        return sb.toString();
    }

    public boolean containsKey(String key) {
        return this.property.containsKey(key);
    }

    public Enumeration<String> keys() {
        return this.property.keys();
    }

    public void setProperty(Map<String, String> p) {
        for (String key : p.keySet()) {
            String value = p.get(key);
            this.setProperty(key, value);
        }
    }

    public void setProperty(PropertyX p) {
        this.property.putAll(p.property);
    }

    public String getCipherValue(String key) {
        String value = this.getProperty(key);
        return this.cipher.decryptIfCipher(value);
    }

    public void setCipherProperty(String key, String value) {
        if (value != null) {
            value = this.cipher.encryptIfPlain(value);
            this.property.put(key, value);
        }
    }

    public StringSet getStringSet(String key, String deli) {
        StringSet set = new StringSet();
        String v = this.getProperty(key);
        if (v != null) {
            String[] vv;
            for (String x : vv = StringUtil.tokenizer(v, deli)) {
                if ((x = StringUtil.trimToEmpty(x)).length() <= 0) continue;
                set.put(x);
            }
        }
        return set;
    }

    public StringLinkedSet getStringLinedSet(String key, String deli) {
        StringLinkedSet set = new StringLinkedSet();
        String v = this.getProperty(key);
        if (v != null) {
            String[] vv;
            for (String x : vv = StringUtil.tokenizer(v, deli)) {
                if ((x = StringUtil.trimToEmpty(x)).length() <= 0) continue;
                set.put(x);
            }
        }
        return set;
    }

    public IntLinkedSet getIntLinedSet(String key, String deli) {
        IntLinkedSet set = new IntLinkedSet();
        String v = this.getProperty(key);
        if (v != null) {
            String[] vv;
            for (String x : vv = StringUtil.tokenizer(v, deli)) {
                if ((x = StringUtil.trimToEmpty(x)).equals("0")) {
                    set.put(0);
                    continue;
                }
                int i = CastUtil.cint(x);
                if (i == 0) continue;
                set.put(i);
            }
        }
        return set;
    }

    public void putAll(Properties m) {
        for (Map.Entry<Object, Object> e : m.entrySet()) {
            this.property.put((String)e.getKey(), (String)e.getValue());
        }
    }
}

