/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.lang.reflect.Array;
import whatap.lang.H1;
import whatap.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MeteringUtil<T> {
    public final int BUCKET_SIZE;
    public final int TIME_UNIT;
    private final Object[] table;
    private long _time_;
    private int _pos_;

    public MeteringUtil() {
        this(1000, 301);
    }

    public MeteringUtil(int bucketSize) {
        this(1000, bucketSize);
    }

    public MeteringUtil(int timeUnit, int bucketSize) {
        this.TIME_UNIT = timeUnit;
        this.BUCKET_SIZE = bucketSize;
        this._time_ = this.getTime();
        this._pos_ = (int)(this._time_ % (long)this.BUCKET_SIZE);
        this.table = new Object[bucketSize];
        for (int i = 0; i < bucketSize; ++i) {
            this.table[i] = this.create();
        }
    }

    protected abstract T create();

    protected abstract void clear(T var1);

    public synchronized T getCurrentBucket() {
        int pos = this.getPosition();
        return (T)this.table[pos];
    }

    public synchronized T getLastBucket() {
        int pos = this.getPosition();
        return (T)this.table[this.stepback(pos)];
    }

    public synchronized T[] getLastTwoBucket() {
        int pos = this.getPosition();
        pos = this.stepback(pos);
        Object t1 = this.table[pos];
        pos = this.stepback(pos);
        Object t2 = this.table[pos];
        if (t1 == null) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(t1.getClass(), 2);
        result[0] = t1;
        result[1] = t2;
        return result;
    }

    public synchronized T getCurrentBucket(long time) {
        int pos = this.getPosition(time);
        if (pos >= 0) {
            return (T)this.table[pos];
        }
        return null;
    }

    public synchronized int getPosition() {
        long curTime = this.getTime();
        if (curTime != this._time_) {
            for (int i = 0; (long)i < curTime - this._time_ && i < this.BUCKET_SIZE; ++i) {
                this._pos_ = this._pos_ + 1 > this.BUCKET_SIZE - 1 ? 0 : this._pos_ + 1;
                this.clear(this.table[this._pos_]);
            }
            this._time_ = curTime;
            this._pos_ = (int)(this._time_ % (long)this.BUCKET_SIZE);
        }
        return this._pos_;
    }

    public synchronized int getPosition(long time) {
        long theTime;
        long curTime = this.getTime();
        if (curTime != this._time_) {
            for (int i = 0; (long)i < curTime - this._time_ && i < this.BUCKET_SIZE; ++i) {
                this._pos_ = this._pos_ + 1 > this.BUCKET_SIZE - 1 ? 0 : this._pos_ + 1;
                this.clear(this.table[this._pos_]);
            }
            this._time_ = curTime;
            this._pos_ = (int)(this._time_ % (long)this.BUCKET_SIZE);
        }
        if ((theTime = time / (long)this.TIME_UNIT) > curTime || theTime < curTime - (long)this.BUCKET_SIZE + 2L) {
            return -1;
        }
        return (int)(theTime % (long)this.BUCKET_SIZE);
    }

    protected int check(int period) {
        if (period >= this.BUCKET_SIZE) {
            period = this.BUCKET_SIZE - 1;
        }
        return period;
    }

    protected int stepback(int pos) {
        pos = pos == 0 ? this.BUCKET_SIZE - 1 : --pos;
        return pos;
    }

    public synchronized int search(int period, H1<T> h) {
        period = this.check(period);
        int pos = this.getPosition();
        try {
            for (int i = 0; i < period; ++i) {
                h.process(this.table[pos]);
                pos = this.stepback(pos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return period;
    }

    public synchronized int search(int period, H1<T> h, int skip) {
        int i;
        period = this.check(period);
        int pos = this.getPosition();
        for (i = 0; i < skip; ++i) {
            pos = this.stepback(pos);
        }
        try {
            for (i = 0; i < period; ++i) {
                h.process(this.table[pos]);
                pos = this.stepback(pos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return period;
    }

    public synchronized T[] search(int period) {
        period = this.check(period);
        int pos = this.getPosition();
        Object[] out = new Object[period];
        for (int i = 0; i < period; ++i) {
            out[i] = this.table[pos];
            pos = this.stepback(pos);
        }
        return out;
    }

    protected long getTime() {
        return DateUtil.currentTime() / (long)this.TIME_UNIT;
    }

    public void reset(long time, T bucket) {
        int pos = this.getPosition(time);
        if (pos >= 0) {
            this.table[pos] = bucket;
        }
    }
}

