/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<E> {
    transient int size = 0;
    transient LinkedListEntity<E> first;
    transient LinkedListEntity<E> last;
    transient int max = 0;

    public synchronized void addFirst(E e) {
        LinkedListEntity<E> f = this.first;
        LinkedListEntity<E> newNode = new LinkedListEntity<E>(null, e, f);
        this.first = newNode;
        if (f == null) {
            this.last = newNode;
        } else {
            f.prev = newNode;
        }
        ++this.size;
        if (this.max > 0) {
            while (this.max < this.size) {
                this.removeLast();
            }
        }
    }

    public synchronized void addLast(E e) {
        LinkedListEntity<E> l = this.last;
        LinkedListEntity<E> newNode = new LinkedListEntity<E>(l, e, null);
        this.last = newNode;
        if (l == null) {
            this.first = newNode;
        } else {
            l.next = newNode;
        }
        ++this.size;
        if (this.max > 0) {
            while (this.max < this.size) {
                this.removeFirst();
            }
        }
    }

    public synchronized LinkedListEntity<E> putBefore(E e, LinkedListEntity<E> succ) {
        LinkedListEntity pred = succ.prev;
        LinkedListEntity newNode = new LinkedListEntity(pred, e, succ);
        succ.prev = newNode;
        if (pred == null) {
            this.first = newNode;
        } else {
            pred.next = newNode;
        }
        ++this.size;
        if (this.max > 0) {
            while (this.max < this.size) {
                this.removeLast();
            }
        }
        return newNode;
    }

    public synchronized E remove(LinkedListEntity<E> x) {
        Object element = x.value;
        LinkedListEntity next = x.next;
        LinkedListEntity prev = x.prev;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
        }
        --this.size;
        return element;
    }

    public LinkedListEntity<E> getFirst() {
        return this.first;
    }

    public LinkedListEntity<E> getLast() {
        return this.last;
    }

    public LinkedListEntity<E> getNext(LinkedListEntity<E> o) {
        return o.next;
    }

    public LinkedListEntity<E> getPrev(LinkedListEntity<E> o) {
        return o.prev;
    }

    public synchronized E removeFirst() {
        LinkedListEntity<E> f = this.first;
        if (f != null) {
            return this.remove(this.first);
        }
        return null;
    }

    public synchronized E removeLast() {
        LinkedListEntity<E> l = this.last;
        if (l != null) {
            return this.remove(l);
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    public synchronized void clear() {
        if (this.size == 0) {
            return;
        }
        LinkedListEntity<E> x = this.first;
        while (x != null) {
            LinkedListEntity next = x.next;
            x.value = null;
            x.next = null;
            x.prev = null;
            x = next;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public synchronized E[] toArray(E[] result) {
        if (result.length != this.size) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), this.size);
        }
        int i = 0;
        LinkedListEntity<E> x = this.first;
        while (x != null && i < this.size) {
            result[i++] = x.value;
            x = x.next;
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean i = false;
        LinkedListEntity<E> x = this.first;
        while (x != null) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(x.value);
            x = x.next;
        }
        return sb.toString();
    }

    public LinkedList<E> setMax(int x) {
        this.max = x;
        return this;
    }

    public static void main(String[] args) {
        LinkedList<String> t = new LinkedList().setMax(3);
        t.add("aaa");
        t.add("bbb");
        t.add("ccc");
        LinkedListEntity<Object> ent = t.getLast();
        ent = t.putBefore("ddd", ent);
        System.out.println(ent.next);
        t.add("eee");
        System.out.println(t);
        t.addFirst("fff");
        System.out.println(t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedListEntity<E> {
        public E value;
        public LinkedListEntity<E> next;
        public LinkedListEntity<E> prev;

        LinkedListEntity(LinkedListEntity<E> prev, E element, LinkedListEntity<E> next) {
            this.value = element;
            this.next = next;
            this.prev = prev;
        }
    }
}

