/*
 * Decompiled with CFR 0.152.
 */
package whatap.reqlog.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import whatap.agent.Logger;
import whatap.reqlog.ReqLogConf;
import whatap.util.DateUtilGmt9;
import whatap.util.FileUtil;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

public class ReqLogFile
extends Thread {
    private static ReqLogFile instance;
    boolean bRun = true;
    PrintWriter out;
    private long curOutDate;
    private static long timeZoneDelta;

    public static synchronized ReqLogFile getInstance() {
        if (instance == null) {
            instance = new ReqLogFile();
            instance.setName("ReqLogFile");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public void run() {
        boolean old_reqlog_file_enabled = ReqLogConf.reqlog_file_enabled;
        if (StringUtil.isNotEmpty(ReqLogConf.reqlog_mount_check)) {
            long last_log = 0L;
            while (!new File(ReqLogConf.reqlog_mount_check).exists()) {
                long now = System.currentTimeMillis();
                if (now - last_log > 3600000L) {
                    Logger.println("Warning!! reqlog mount check fail: " + ReqLogConf.reqlog_mount_check);
                }
                ThreadUtil.sleep(10000L);
            }
        }
        long checkInterval = 10800000L;
        long lastCheck = System.currentTimeMillis();
        while (this.bRun) {
            long now = System.currentTimeMillis();
            if (this.out == null || this.curOutDate != ReqLogFile.dateTime(now) || old_reqlog_file_enabled != ReqLogConf.reqlog_file_enabled) {
                this.reopen(now);
                if (this.out == null) {
                    Logger.println("reqlog logfile open fail, try again after 120sec");
                    ThreadUtil.sleep(120000L);
                }
                old_reqlog_file_enabled = ReqLogConf.reqlog_file_enabled;
            }
            if (ReqLogConf.reqlog_clean_enabled && now - lastCheck > 10800000L) {
                lastCheck = now;
                this.clean();
            }
            ThreadUtil.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean() {
        File base = new File(ReqLogConf.reqlog_base);
        if (!base.exists()) {
            return;
        }
        File lock = new File(base, "lock");
        try {
            if (!lock.createNewFile()) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        Logger.println("ReqLog clean start");
        try {
            long now = System.currentTimeMillis();
            long delta = 86400000L * (long)ReqLogConf.reqlog_keep_date;
            if (delta < 86400000L) {
                return;
            }
            File[] children = base.listFiles();
            for (int i = 0; i < children.length; ++i) {
                File f = children[i];
                if (f.getName().startsWith(".") || f.getName().length() < 10) continue;
                try {
                    int len = f.getName().length();
                    String yyyyMMdd = f.getName().substring(len - 8);
                    long ftime = DateUtilGmt9.yyyymmdd(yyyyMMdd);
                    if (now - delta <= ftime) continue;
                    f.delete();
                    Logger.green("ReqLog delete " + f.getName());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Throwable t) {
            Logger.println("ReqLog", t.toString());
        }
        finally {
            lock.delete();
        }
        Logger.println("ReqLog clean done");
    }

    private void reopen(long time) {
        PrintWriter old = this.out;
        this.curOutDate = ReqLogFile.dateTime(time);
        this.out = this.open(time);
        FileUtil.close(old);
    }

    private static long dateTime(long tm) {
        return (tm + timeZoneDelta) / 86400000L;
    }

    private PrintWriter open(long time) {
        String fileName = ReqLogConf.reqlog_file + "." + DateUtilGmt9.yyyymmdd(time);
        File base = new File(ReqLogConf.reqlog_base);
        base.mkdirs();
        File file = new File(base, fileName);
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file, true), ReqLogConf.reqlog_file_buffer_size));
            Logger.println("reqlog file open: " + file);
            return pw;
        }
        catch (Exception e) {
            Logger.println("reqlog file open fail: " + e);
            return null;
        }
    }

    static {
        timeZoneDelta = 32400000L;
    }
}

