/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.plugin;

import java.util.List;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPerfX;
import whatap.perfx.plugin.PerfXLoader;
import whatap.perfx.plugin.PerfXRun;
import whatap.util.ThreadUtil;

public class PerfXPlugExecutor
extends Thread {
    private static PerfXPlugExecutor instance;
    List<PerfXRun> plugin;
    long lastLoadTime;

    public static synchronized PerfXPlugExecutor getInstance() {
        if (instance == null) {
            instance = new PerfXPlugExecutor();
            instance.setDaemon(true);
            instance.setName("WhTap-PerfX-Plugin");
            instance.setPriority(4);
            instance.start();
        }
        return instance;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (!ConfPerfX.perfx_plugin_enabled) {
                        ThreadUtil.sleep(10000L);
                        continue;
                    }
                    this.process(System.currentTimeMillis() / 1000L * 1000L);
                    ThreadUtil.sleep(1000L);
                }
            }
            catch (Throwable t) {
                Logger.println("perfx-plugin-exec", t.toString(), t);
                ThreadUtil.sleep(300000L);
                continue;
            }
            break;
        }
    }

    public void process(long time) {
        List<PerfXRun> plugList = this.plugin;
        if (plugList == null) {
            return;
        }
        for (PerfXRun perfx : plugList) {
            try {
                if (perfx.isTooManyFail() || time < perfx.getLastRunTime() + (long)perfx.getInterval()) continue;
                perfx.setLastRunTime(time);
                perfx.process();
            }
            catch (Throwable t) {
                perfx.addFail();
                Logger.println("perfx-plugin-exec", 10, t);
            }
        }
    }

    public void load() {
        long now = System.currentTimeMillis();
        long interval = ConfPerfX.perfx_plugin_load_interval;
        if (this.plugin != null && this.plugin.size() > 0) {
            interval *= 6L;
        }
        if (now - this.lastLoadTime > interval) {
            this.lastLoadTime = now;
            this.plugin = PerfXLoader.load(ConfPerfX.perfx_plugin_libroot, null);
        }
    }
}

