/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import whatap.agent.Logger;
import whatap.util.AnsiPrint;
import whatap.util.FileUtil;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarLibBox {
    private int nameHash;
    private long sizeSum;
    private long timeHash;
    private List<File> jarFiles;

    public boolean equals(JarLibBox o) {
        if (this.nameHash != o.nameHash) {
            return false;
        }
        if (this.sizeSum != o.sizeSum) {
            return false;
        }
        if (this.timeHash != o.timeHash) {
            return false;
        }
        return this.size() == o.size();
    }

    public int size() {
        return this.jarFiles == null ? 0 : this.jarFiles.size();
    }

    public static JarLibBox load(String dir) {
        File[] files;
        JarLibBox out = new JarLibBox();
        if (StringUtil.isEmpty(dir)) {
            return out;
        }
        File dirRoot = new File(dir);
        if (!dirRoot.exists()) {
            return out;
        }
        for (File file : files = dirRoot.listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".jar")) continue;
            out.nameHash ^= file.getName().hashCode();
            out.sizeSum += file.length();
            out.timeHash ^= file.lastModified();
            if (out.jarFiles == null) {
                out.jarFiles = new ArrayList<File>();
            }
            out.jarFiles.add(file);
        }
        return out;
    }

    public URL[] getURLs() {
        URL[] urls = new URL[this.size()];
        for (int i = 0; i < urls.length; ++i) {
            try {
                urls[i] = this.jarFiles.get(i).toURI().toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Set<String> getPerfXClasses() {
        HashSet<String> out = new HashSet<String>();
        for (File f : this.jarFiles) {
            JarFile jar;
            block7: {
                jar = null;
                try {
                    jar = new JarFile(f);
                    Manifest mf = jar.getManifest();
                    if (mf == null) break block7;
                    Attributes attr = mf.getMainAttributes();
                    String val = attr.getValue("PerfX-Classes");
                    if (StringUtil.isEmpty(val)) {
                        Logger.yellow(AnsiPrint.red("The attribute \u2018PerfX-Classes\u2019 is missing from " + f.getName()));
                        break block7;
                    }
                    String[] classes = StringUtil.tokenizer(val, ",");
                    if (classes == null) break block7;
                    for (String className : classes) {
                        out.add(className);
                    }
                }
                catch (Exception exception) {
                    FileUtil.close(jar);
                    continue;
                    catch (Throwable throwable) {
                        FileUtil.close(jar);
                        throw throwable;
                    }
                }
            }
            FileUtil.close(jar);
        }
        return out;
    }

    public URLClassLoader getClassLoader(ClassLoader parent) {
        return new URLClassLoader(this.getURLs(), parent);
    }
}

