/*
 * Decompiled with CFR 0.152.
 */
package whatap.logsink;

import whatap.agent.Logger;
import whatap.agent.conf.ConfLogSink;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.EventPack;
import whatap.lang.value.Value;
import whatap.logsink.LineLog;
import whatap.util.CastUtil;

public class LineLogUtil {
    static long last_log = System.currentTimeMillis();
    static long last_alert = System.currentTimeMillis();

    public static void checkLogContent(LineLog lineLog, String orgContent) {
        if (orgContent == null) {
            return;
        }
        if (orgContent != null) {
            int len = orgContent.length();
            if (ConfLogSink.logsink_limit_content_enabled && len > ConfLogSink.logsink_limit_content_length) {
                lineLog.content = orgContent.substring(0, ConfLogSink.logsink_limit_content_length) + " ...(truncated)";
                lineLog.truncated = true;
                lineLog.orgContentLength = len;
            } else {
                lineLog.content = orgContent;
            }
        }
    }

    public static void log(LineLog lineLog) {
        String message = LineLogUtil.createLogMessage(lineLog);
        LineLogUtil.log(message);
        LineLogUtil.alertLogTruncated(message);
    }

    private static String createLogMessage(LineLog lineLog) {
        StringBuilder sb = new StringBuilder();
        sb.append("LOG_TRUNCATED: too big log").append("\n");
        sb.append("category: ").append(lineLog.category).append("\n");
        Value txidVal = lineLog.fields.get("@txid");
        if (txidVal != null) {
            sb.append("txid: ").append(CastUtil.clong(txidVal)).append("\n");
        }
        String parts = lineLog.content.substring(0, 20);
        sb.append("content: ").append(parts).append("...\n");
        sb.append("original content length: ").append(lineLog.orgContentLength).append("\n");
        return sb.toString();
    }

    private static void log(String message) {
        if (!ConfLogSink.debug_logsink_limit_content_enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - last_log < (long)ConfLogSink.logsink_limit_content_log_silent_time) {
            return;
        }
        last_log = now;
        Logger.println(message);
    }

    private static void alertLogTruncated(String message) {
        if (!ConfLogSink.logsink_limit_content_alert_enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - last_alert < (long)ConfLogSink.logsink_limit_content_alert_silent_time) {
            return;
        }
        last_alert = now;
        EventPack e = new EventPack();
        e.level = (byte)30;
        e.title = "LOG_TRUNCATED";
        e.status = 1;
        e.message = message;
        DataPackSender.send(e);
    }

    public static void addTruncatedTag(LineLog lineLog) {
        lineLog.tags.put("@truncated", "true");
    }
}

