/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.step;

import java.io.IOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.step.Step;
import whatap.util.BitUtil;
import whatap.util.HashUtil;
import whatap.util.IPUtil;

public class SocketStep
extends Step {
    public byte[] ipaddr;
    public int port;
    public int elapsed;
    public long error;

    public SocketStep() {
    }

    public SocketStep(byte[] ipaddr, int port) {
        this.ipaddr = ipaddr;
        this.port = port;
    }

    public int getElapsed() {
        return this.elapsed;
    }

    public byte getStepType() {
        return 5;
    }

    public String toString() {
        return IPUtil.toString(this.ipaddr) + ":" + this.port;
    }

    public void write(DataOutputX out) throws IOException {
        super.write(out);
        out.writeBlob(this.ipaddr);
        out.writeDecimal(this.port);
        out.writeDecimal(this.elapsed);
        out.writeDecimal(this.error);
    }

    public Step read(DataInputX in) throws IOException {
        super.read(in);
        this.ipaddr = in.readBlob();
        this.port = (int)in.readDecimal();
        this.elapsed = (int)in.readDecimal();
        this.error = in.readDecimal();
        return this;
    }

    public long getSocketId() {
        return BitUtil.composite(HashUtil.hash(this.ipaddr), this.port);
    }
}

