/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.slog;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import whatap.lang.slog.Fmt;
import whatap.lang.slog.SLog;
import whatap.lang.slog.Type;
import whatap.lang.value.MapValue;
import whatap.lang.value.Value;
import whatap.util.CastUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMap {
    StringKeyLinkedMap<String> buffer = new StringKeyLinkedMap();
    private static String none = "\"\"";
    private static SimpleDateFormat timeformat = new SimpleDateFormat("HH:mm:ss.SSS");
    private static SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public StringEnumer keys() {
        return this.buffer.keys();
    }

    public String getValue(String key) {
        return this.buffer.get(key);
    }

    public SMap put(String key, String value) {
        this.buffer.put(key, this.addText(value));
        return this;
    }

    private String addText(String value) {
        if (value == null) {
            return none;
        }
        boolean hasSpace = false;
        char[] str = value.toCharArray();
        block4: for (int i = 0; i < str.length; ++i) {
            switch (str[i]) {
                case '\"': {
                    str[i] = 39;
                    continue block4;
                }
                case ' ': {
                    hasSpace = true;
                }
            }
        }
        if (hasSpace) {
            StringBuilder b = new StringBuilder();
            b.append('\"');
            b.append(str);
            b.append('\"');
            return b.toString();
        }
        return new String(str);
    }

    public SMap append(String key, Object value) {
        if (value == null) {
            this.buffer.put(key, none);
        } else if (value instanceof String) {
            this.buffer.put(key, this.addText((String)value));
        } else if (value instanceof Number) {
            if (value instanceof Float || value instanceof Double) {
                this.buffer.put(key, new DecimalFormat("#0.0#######").format(value));
            } else {
                this.buffer.put(key, String.valueOf(value));
            }
        } else {
            this.buffer.put(key, this.addText(value.toString()));
        }
        return this;
    }

    public SMap append(String key, long value) {
        this.buffer.put(key, String.valueOf(value));
        return this;
    }

    public SMap append(String key, float value) {
        this.buffer.put(key, new DecimalFormat("#0.0#######").format(value));
        return this;
    }

    public SMap append(String key, double value) {
        this.buffer.put(key, new DecimalFormat("#0.0#######").format(value));
        return this;
    }

    public SMap append(String key, float value, String format) {
        this.buffer.put(key, new DecimalFormat(format).format(value));
        return this;
    }

    public SMap append(String key, double value, String format) {
        this.buffer.put(key, new DecimalFormat(format).format(value));
        return this;
    }

    public String toString() {
        return this.str();
    }

    public String str() {
        return new SLog().a(this).toString();
    }

    public SMap time(String key, Date time) {
        this.buffer.put(key, timeformat.format(time));
        return this;
    }

    public SMap t(String key, Date date) {
        return this.time(key, date);
    }

    public SMap t(String key, long date) {
        return this.time(key, new Date(date));
    }

    public SMap date(String key, Date date) {
        this.buffer.put(key, dateformat.format(date));
        return this;
    }

    public SMap d(String key, Date date) {
        return this.date(key, date);
    }

    public SMap d(String key, long date) {
        return this.date(key, new Date(date));
    }

    public SMap timestamp(String key, Date date) {
        this.buffer.put(key, '\"' + timestampFormat.format(date) + '\"');
        return this;
    }

    public SMap ts(String key, Date date) {
        return this.timestamp(key, date);
    }

    public SMap ts(String key, long date) {
        return this.timestamp(key, new Date(date));
    }

    public SMap append(MapValue m) {
        SMap slog = this;
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = m.entries();
        block4: while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
            switch (ent.getValue().getValueType()) {
                case 20: 
                case 21: 
                case 22: 
                case 46: {
                    slog.append(ent.getKey(), ((Number)((Object)ent.getValue())).longValue());
                    continue block4;
                }
                case 30: 
                case 40: 
                case 82: {
                    slog.append(ent.getKey(), ((Number)((Object)ent.getValue())).doubleValue());
                    continue block4;
                }
            }
            slog.append(ent.getKey(), (Object)ent.getValue().toString());
        }
        return slog;
    }

    public SMap append(MapValue m, Fmt keyfmt, Fmt valfmt) {
        SMap slog = this;
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = m.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
            slog.append(keyfmt.format(ent.getKey()), (Object)valfmt.format(ent.getValue()));
        }
        return slog;
    }

    public SMap append(MapValue m, String prefix) {
        if (m == null) {
            return this;
        }
        SMap slog = this;
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = m.entries();
        block4: while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
            switch (ent.getValue().getValueType()) {
                case 20: 
                case 21: 
                case 22: 
                case 46: {
                    slog.append(ent.getKey() + prefix, ((Number)((Object)ent.getValue())).longValue());
                    continue block4;
                }
                case 30: 
                case 40: 
                case 82: {
                    slog.append(ent.getKey() + prefix, ((Number)((Object)ent.getValue())).doubleValue());
                    continue block4;
                }
            }
            slog.append(ent.getKey() + prefix, (Object)ent.getValue().toString());
        }
        return slog;
    }

    public SMap append(MapValue m, Map<String, Type> types) {
        SMap slog = this;
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = m.entries();
        block9: while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
            Type t = types.get(ent.getKey());
            if (t != null) {
                switch (t) {
                    case date: {
                        slog.date(ent.getKey(), new Date(CastUtil.clong(ent.getValue())));
                        break;
                    }
                    case time: {
                        slog.time(ent.getKey(), new Date(CastUtil.clong(ent.getValue())));
                        break;
                    }
                    case timestamp: {
                        slog.timestamp(ent.getKey(), new Date(CastUtil.clong(ent.getValue())));
                    }
                }
                continue;
            }
            switch (ent.getValue().getValueType()) {
                case 20: 
                case 21: 
                case 22: 
                case 46: {
                    slog.append(ent.getKey(), ((Number)((Object)ent.getValue())).longValue());
                    continue block9;
                }
                case 30: 
                case 40: 
                case 82: {
                    slog.append(ent.getKey(), ((Number)((Object)ent.getValue())).doubleValue());
                    continue block9;
                }
            }
            slog.append(ent.getKey(), (Object)ent.getValue().toString());
        }
        return slog;
    }

    public SMap append(Map m) {
        SMap slog = this;
        for (Map.Entry ent : m.entrySet()) {
            if (ent.getValue() instanceof Number) {
                if (ent.getValue() instanceof Long || ent.getValue() instanceof Integer) {
                    slog.append(this.noSpace(ent.getKey().toString()), ((Number)ent.getValue()).longValue());
                    continue;
                }
                slog.append(this.noSpace(ent.getKey().toString()), ((Number)ent.getValue()).doubleValue());
                continue;
            }
            slog.append(this.noSpace(ent.getKey().toString()), (Object)ent.getValue().toString());
        }
        return slog;
    }

    private String noSpace(String v) {
        boolean notMod = true;
        char[] k = v.toCharArray();
        for (int i = 0; i < k.length; ++i) {
            if (k[i] != ' ') continue;
            notMod = false;
            k[i] = 95;
        }
        return notMod ? v : new String(k);
    }

    public SMap append(Map m, String prefix) {
        SMap slog = this;
        for (Map.Entry ent : m.entrySet()) {
            if (ent.getValue() instanceof Number) {
                if (ent.getValue() instanceof Long || ent.getValue() instanceof Integer) {
                    slog.append(this.noSpace(prefix + ent.getKey()), ((Number)ent.getValue()).longValue());
                    continue;
                }
                slog.append(this.noSpace(prefix + ent.getKey()), ((Number)ent.getValue()).doubleValue());
                continue;
            }
            slog.append(this.noSpace(prefix + ent.getKey()), (Object)ent.getValue().toString());
        }
        return slog;
    }

    public SMap a(String key, String value) {
        return this.append(key, (Object)value);
    }

    public SMap a(String key, long value) {
        return this.append(key, value);
    }

    public SMap a(String key, double value) {
        return this.append(key, value);
    }

    public SMap a(String key, Object value) {
        return this.append(key, value);
    }

    public SMap a(Map value) {
        return this.append(value);
    }

    public SMap a(MapValue value) {
        return this.append(value);
    }

    public SMap a(Map m, String prefix) {
        return this.append(m, prefix);
    }

    public SMap a(MapValue m, String prefix) {
        return this.append(m, prefix);
    }

    public static SMap n(String key, String value) {
        return SMap.New(key, value);
    }

    public static SMap n(String key, long value) {
        return SMap.New(key, value);
    }

    public static SMap n(String key, double value) {
        return SMap.New(key, value);
    }

    public static SMap New(String key, String value) {
        return new SMap().append(key, (Object)value);
    }

    public static SMap New(String key, long value) {
        return new SMap().append(key, value);
    }

    public static SMap New(String key, double value) {
        return new SMap().append(key, value);
    }
}

