/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.service;

import java.util.Enumeration;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.MapValue;
import whatap.lang.value.Value;
import whatap.util.StringKeyLinkedMap;

public class TxRecord {
    public long txid;
    public long endTime;
    public int service;
    public int elapsed;
    public long error;
    public int cpuTime;
    public long malloc;
    public int sqlCount;
    public int sqlTime;
    public int sqlFetchCount;
    public int sqlFetchTime;
    public int httpcCount;
    public int httpcTime;
    public boolean active;
    public long step_data_pos;
    public int cipher;
    public int ipaddr;
    public long wclientId;
    public int userAgent;
    public int referer;
    public int status;
    public long mtid;
    public int mdepth;
    public long mcaller;
    public long mcaller_pcode;
    public int mcaller_okind;
    public int mcaller_oid;
    public int mcaller_spec;
    public int mcaller_url;
    public int mthis_spec;
    public byte http_method;
    public int domain;
    public MapValue fields;
    public int login;
    public byte errorLevel;
    public int oid;
    public int okind;
    public int onode;
    public String custid;
    public int dbcTime;
    public byte apdex;
    public long mcallerStepId;
    public String originUrl;
    public int step_split_count;
    public int methodCount;
    public int methodTime;
    public String appctx;
    public String txName;
    public String error_class;
    public String error_message;

    public void write(DataOutputX dout) {
        dout.writeByte(10);
        DataOutputX o = new DataOutputX();
        o.writeLong(this.txid);
        o.writeDecimal(this.endTime);
        o.writeDecimal(this.service);
        o.writeDecimal(this.elapsed);
        o.writeDecimal(this.error);
        o.writeDecimal(this.cpuTime);
        o.writeDecimal(this.malloc);
        o.writeDecimal(this.sqlCount);
        o.writeDecimal(this.sqlTime);
        o.writeDecimal(this.sqlFetchCount);
        o.writeDecimal(this.sqlFetchTime);
        o.writeDecimal(this.httpcCount);
        o.writeDecimal(this.httpcTime);
        o.writeBoolean(this.active);
        o.writeDecimal(this.step_data_pos);
        o.writeDecimal(this.cipher);
        o.writeInt(this.ipaddr);
        o.writeDecimal(this.wclientId);
        o.writeDecimal(this.userAgent);
        o.writeDecimal(this.referer);
        o.writeDecimal(this.status);
        if (this.mtid != 0L) {
            o.writeByte(1);
            o.writeDecimal(this.mtid);
            o.writeDecimal(this.mdepth);
            o.writeDecimal(this.mcaller);
        } else {
            o.writeByte(0);
        }
        o.writeByte(6);
        o.writeDecimal(this.mcaller_pcode);
        o.writeDecimal(this.mcaller_okind);
        o.writeDecimal(this.mcaller_oid);
        o.writeDecimal(this.mcaller_spec);
        o.writeDecimal(this.mcaller_url);
        o.writeDecimal(this.mthis_spec);
        o.writeByte(this.http_method);
        o.writeDecimal(this.domain);
        if (this.fields == null) {
            o.writeByte(0);
        } else {
            int sz = this.fields.size();
            o.writeByte(sz);
            Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = this.fields.entries();
            while (en.hasMoreElements()) {
                StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
                o.writeText(ent.getKey());
                o.writeValue(ent.getValue());
            }
        }
        o.writeDecimal(this.login);
        o.writeByte(this.errorLevel);
        o.writeDecimal(this.oid);
        o.writeDecimal(this.okind);
        o.writeDecimal(this.onode);
        o.writeText(this.custid);
        o.writeDecimal(this.dbcTime);
        o.writeByte(this.apdex);
        o.writeDecimal(this.mcallerStepId);
        o.writeText(this.originUrl);
        o.writeDecimal(this.step_split_count);
        o.writeDecimal(this.methodCount);
        o.writeDecimal(this.methodTime);
        o.writeText(this.appctx);
        o.writeText(this.txName);
        o.writeText(this.error_class);
        o.writeText(this.error_message);
        dout.writeBlob(o.toByteArray());
    }

    public TxRecord read(DataInputX din) {
        byte ver = din.readByte();
        if (ver < 10) {
            throw new RuntimeException("not supported version TxRecord");
        }
        DataInputX in = new DataInputX(din.readBlob());
        this.txid = in.readLong();
        this.endTime = in.readDecimal();
        this.service = (int)in.readDecimal();
        this.elapsed = (int)in.readDecimal();
        this.error = in.readDecimal();
        this.cpuTime = (int)in.readDecimal();
        this.malloc = in.readDecimal();
        this.sqlCount = (int)in.readDecimal();
        this.sqlTime = (int)in.readDecimal();
        this.sqlFetchCount = (int)in.readDecimal();
        this.sqlFetchTime = (int)in.readDecimal();
        this.httpcCount = (int)in.readDecimal();
        this.httpcTime = (int)in.readDecimal();
        this.active = in.readBoolean();
        this.step_data_pos = in.readDecimal();
        this.cipher = (int)in.readDecimal();
        this.ipaddr = in.readInt();
        this.wclientId = in.readDecimal();
        this.userAgent = (int)in.readDecimal();
        this.referer = (int)in.readDecimal();
        this.status = (int)in.readDecimal();
        if (in.readByte() > 0) {
            this.mtid = in.readDecimal();
            this.mdepth = (int)in.readDecimal();
            this.mcaller = in.readDecimal();
        }
        switch (in.readByte()) {
            case 1: {
                this.mcaller_pcode = in.readDecimal();
                break;
            }
            case 3: {
                this.mcaller_pcode = in.readDecimal();
                this.mcaller_spec = (int)in.readDecimal();
                this.mcaller_url = (int)in.readDecimal();
                break;
            }
            case 4: {
                this.mcaller_pcode = in.readDecimal();
                this.mcaller_spec = (int)in.readDecimal();
                this.mcaller_url = (int)in.readDecimal();
                this.mthis_spec = (int)in.readDecimal();
                break;
            }
            case 5: {
                this.mcaller_pcode = in.readDecimal();
                this.mcaller_oid = (int)in.readDecimal();
                this.mcaller_spec = (int)in.readDecimal();
                this.mcaller_url = (int)in.readDecimal();
                this.mthis_spec = (int)in.readDecimal();
                break;
            }
            case 6: {
                this.mcaller_pcode = in.readDecimal();
                this.mcaller_okind = (int)in.readDecimal();
                this.mcaller_oid = (int)in.readDecimal();
                this.mcaller_spec = (int)in.readDecimal();
                this.mcaller_url = (int)in.readDecimal();
                this.mthis_spec = (int)in.readDecimal();
            }
        }
        this.http_method = in.readByte();
        this.domain = (int)in.readDecimal();
        int n = in.readByte() & 0xFF;
        if (n > 0) {
            this.fields = new MapValue();
            for (int i = 0; i < n; ++i) {
                String key = in.readText();
                Value val = in.readValue();
                this.fields.put(key, val);
            }
        }
        if (in.available() > 0) {
            this.login = (int)in.readDecimal();
        }
        if (in.available() > 0) {
            this.errorLevel = in.readByte();
        } else if (this.error != 0L) {
            this.errorLevel = (byte)20;
        }
        if (in.available() > 0) {
            this.oid = (int)in.readDecimal();
            this.okind = (int)in.readDecimal();
            this.onode = (int)in.readDecimal();
        }
        if (in.available() > 0) {
            this.custid = in.readText();
        }
        if (in.available() > 0) {
            this.dbcTime = (int)in.readDecimal();
        }
        if (in.available() > 0) {
            this.apdex = in.readByte();
        }
        if (in.available() > 0) {
            this.mcallerStepId = in.readDecimal();
            this.originUrl = in.readText();
        }
        if (in.available() > 0) {
            this.step_split_count = (int)in.readDecimal();
        }
        if (in.available() > 0) {
            this.methodCount = (int)in.readDecimal();
            this.methodTime = (int)in.readDecimal();
        }
        if (in.available() > 0) {
            this.appctx = in.readText();
        }
        if (in.available() > 0) {
            this.txName = in.readText();
        }
        if (in.available() > 0) {
            this.error_class = in.readText();
            this.error_message = in.readText();
        }
        return this;
    }

    public byte[] toBytes() {
        DataOutputX o = new DataOutputX();
        this.write(o);
        return o.toByteArray();
    }

    public TxRecord toObject(byte[] b) {
        this.read(new DataInputX(b));
        return this;
    }
}

