/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.util.ArrayUtil;
import whatap.util.CompressUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipPack
extends AbstractPack {
    public byte[] records;
    public int recordCount;
    public byte status;

    @Override
    public short getPackType() {
        return 5899;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ZipPack ");
        sb.append(super.toString());
        sb.append("records=" + ArrayUtil.len(this.records) + "bytes");
        return sb.toString();
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeByte(this.status);
        dout.writeDecimal(this.recordCount);
        dout.writeBlob(this.records);
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        this.status = din.readByte();
        this.recordCount = (int)din.readDecimal();
        this.records = din.readBlob();
        return this;
    }

    public ZipPack setRecords(int size, Enumeration<AbstractPack> items) {
        this.recordCount = size;
        DataOutputX o = new DataOutputX();
        for (int i = 0; i < size; ++i) {
            o.writePack(items.nextElement());
        }
        this.records = o.toByteArray();
        return this;
    }

    public ZipPack setRecords(List<AbstractPack> items) {
        this.recordCount = items.size();
        DataOutputX o = new DataOutputX();
        for (int i = 0; i < items.size(); ++i) {
            o.writePack(items.get(i));
        }
        this.records = o.toByteArray();
        return this;
    }

    public List<AbstractPack> getRecords() {
        ArrayList<AbstractPack> items = new ArrayList<AbstractPack>();
        if (this.records == null) {
            return null;
        }
        DataInputX in = new DataInputX(this.records);
        for (int i = 0; i < this.recordCount; ++i) {
            AbstractPack p = (AbstractPack)in.readPack();
            p.pcode = this.pcode;
            p.oid = this.oid;
            p.okind = this.okind;
            p.onode = this.onode;
            items.add(p);
        }
        return items;
    }

    public ZipPack doZip(int limit) {
        if (this.status != 0) {
            return this;
        }
        if (this.records == null || this.records.length < limit) {
            return this;
        }
        this.status = 1;
        this.records = CompressUtil.doZip(this.records);
        return this;
    }

    public static List<AbstractPack> toList(AbstractPack ... p) {
        return Arrays.asList(p);
    }
}

