/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.pack.SqlRec;
import whatap.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatSqlPack
extends AbstractPack {
    public byte[] records;
    public int record_count;
    private short packType;
    public long dataStartTime;

    public StatSqlPack() {
        this(2560);
    }

    public StatSqlPack(short t) {
        this.packType = t;
    }

    @Override
    public short getPackType() {
        return this.packType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StatSql ");
        sb.append(super.toString());
        sb.append(",records=" + this.record_count);
        sb.append(",bytes=" + ArrayUtil.len(this.records));
        return sb.toString();
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeBlob(this.records);
        dout.writeDecimal(this.record_count);
        if (this.packType == 2560) {
            return;
        }
        DataOutputX o = new DataOutputX();
        o.writeDecimal(this.dataStartTime);
        dout.writeBlob(o.toByteArray());
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        this.records = din.readBlob();
        this.record_count = (int)din.readDecimal();
        if (this.packType == 2560) {
            return this;
        }
        DataInputX in = new DataInputX(din.readBlob());
        this.dataStartTime = in.readDecimal();
        return this;
    }

    public StatSqlPack setRecords(int size, Enumeration<SqlRec> items) {
        DataOutputX o = new DataOutputX();
        o.writeShort(size);
        for (int i = 0; i < size; ++i) {
            items.nextElement().write(o);
        }
        this.records = o.toByteArray();
        this.record_count = size;
        return this;
    }

    public StatSqlPack setRecords(List<SqlRec> items) {
        DataOutputX o = new DataOutputX();
        o.writeShort(items.size());
        for (int i = 0; i < items.size(); ++i) {
            items.get(i).write(o);
        }
        this.records = o.toByteArray();
        this.record_count = items.size();
        return this;
    }

    public StatSqlPack setRecords(List<SqlRec> items, boolean v2) {
        DataOutputX o = new DataOutputX();
        o.writeShort(items.size());
        for (int i = 0; i < items.size(); ++i) {
            items.get(i).write(o, v2);
        }
        this.records = o.toByteArray();
        this.record_count = items.size();
        return this;
    }

    public List<SqlRec> getRecords() {
        ArrayList<SqlRec> items = new ArrayList<SqlRec>();
        if (this.records == null) {
            return items;
        }
        DataInputX in = new DataInputX(this.records);
        int size = in.readShort() & 0xFFFF;
        for (int i = 0; i < size; ++i) {
            items.add(new SqlRec().read(in));
        }
        return items;
    }
}

