/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.util.ArrayUtil;
import whatap.util.BitUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatErrorPack
extends AbstractPack {
    public byte[] records;
    public int record_count;
    private short packType;
    public long dataStartTime;

    public StatErrorPack() {
        this(3072);
    }

    public StatErrorPack(short t) {
        this.packType = t;
    }

    @Override
    public short getPackType() {
        return this.packType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StatError ");
        sb.append(super.toString());
        sb.append(",records=" + this.record_count);
        sb.append(",bytes=" + ArrayUtil.len(this.records));
        return sb.toString();
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeBlob(this.records);
        dout.writeDecimal(this.record_count);
        if (this.packType == 3072) {
            return;
        }
        DataOutputX o = new DataOutputX();
        o.writeDecimal(this.dataStartTime);
        dout.writeBlob(o.toByteArray());
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        this.records = din.readBlob();
        this.record_count = (int)din.readDecimal();
        if (this.packType == 3072) {
            return this;
        }
        DataInputX in = new DataInputX(din.readBlob());
        this.dataStartTime = in.readDecimal();
        return this;
    }

    public StatErrorPack setRecords(int size, Enumeration<ErrorRec> items) {
        DataOutputX o = new DataOutputX();
        o.writeShort(size);
        for (int i = 0; i < size; ++i) {
            StatErrorPack.writeRec(o, items.nextElement());
        }
        this.records = o.toByteArray();
        this.record_count = size;
        return this;
    }

    public StatErrorPack setRecords(List<ErrorRec> items) {
        DataOutputX o = new DataOutputX();
        o.writeShort(items.size());
        for (int i = 0; i < items.size(); ++i) {
            StatErrorPack.writeRec(o, items.get(i));
        }
        this.records = o.toByteArray();
        this.record_count = items.size();
        return this;
    }

    public static void writeRec(DataOutputX o, ErrorRec m) {
        o.writeInt(m.classHash);
        o.writeInt(m.service);
        o.writeLong(m.errorSnapId);
        o.writeDecimal(m.msg);
        o.writeDecimal(m.count);
    }

    public static ErrorRec readRec(DataInputX in) {
        ErrorRec m = new ErrorRec();
        m.classHash = in.readInt();
        m.service = in.readInt();
        m.errorSnapId = in.readLong();
        m.msg = (int)in.readDecimal();
        m.count = (int)in.readDecimal();
        return m;
    }

    public List<ErrorRec> getRecords() {
        ArrayList<ErrorRec> items = new ArrayList<ErrorRec>();
        if (this.records == null) {
            return null;
        }
        DataInputX in = new DataInputX(this.records);
        int size = in.readShort();
        for (int i = 0; i < size; ++i) {
            items.add(StatErrorPack.readRec(in));
        }
        return items;
    }

    public static class ErrorRec {
        public int classHash;
        public int service;
        public long errorSnapId;
        public int msg;
        public int count;

        public void merge(ErrorRec o) {
            this.count += o.count;
        }

        public long getKey() {
            return BitUtil.composite(this.classHash, this.service);
        }

        public ErrorRec setClassAndTxUrl(int classHash, int txUrl) {
            this.classHash = classHash;
            this.service = txUrl;
            return this;
        }
    }
}

