/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.conf;

import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import whatap.lang.value.BooleanValue;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.DoubleValue;
import whatap.lang.value.FloatValue;
import whatap.lang.value.NullValue;
import whatap.lang.value.TextValue;
import whatap.lang.value.Value;
import whatap.org.json.JSONObject;
import whatap.util.ArrayUtil;
import whatap.util.ParamText;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigValueUtil {
    public static Properties replaceSysProp(Properties temp) {
        Properties p = new Properties();
        HashMap<Object, Object> args = new HashMap<Object, Object>();
        args.putAll(System.getenv());
        args.putAll(System.getProperties());
        p.putAll((Map<?, ?>)args);
        p.remove("whatap.env");
        for (String string : temp.keySet()) {
            String value = (String)temp.get(string);
            p.put(string, new ParamText(StringUtil.trim(value)).getText(args));
        }
        String string = System.getenv("whatap.env");
        if (string != null) {
            try {
                Properties ee = new Properties();
                ee.load(new StringReader(string));
                p.putAll((Map<?, ?>)ee);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return p;
    }

    public static StringKeyLinkedMap<Object> getConfigDefault(Object o) {
        StringKeyLinkedMap<Object> map = new StringKeyLinkedMap<Object>();
        Field[] fields = o.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            int mod = fields[i].getModifiers();
            if (Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            try {
                String name = fields[i].getName();
                Object value = fields[i].get(o);
                map.put(name, value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public static Value toValue(Object o) {
        if (o == null) {
            return new NullValue();
        }
        if (o instanceof Float) {
            return new FloatValue(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return new DoubleValue((Double)o);
        }
        if (o instanceof Number) {
            return new DecimalValue(((Number)o).longValue());
        }
        if (o instanceof Boolean) {
            return new BooleanValue((Boolean)o);
        }
        if (o.getClass().isArray()) {
            String s = ArrayUtil.toString(o);
            return new TextValue(s.substring(1, s.length() - 1));
        }
        return new TextValue(o.toString());
    }

    public static void jsonToSystemProperties(String opts) {
        try {
            if (StringUtil.isEmpty(opts)) {
                return;
            }
            JSONObject jo = new JSONObject(opts);
            Iterator<String> itr = jo.keys();
            while (itr.hasNext()) {
                String key = itr.next();
                String value = jo.optString(key);
                System.out.println(key + "=" + value);
                System.setProperty(key, value);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

