/*
 * Decompiled with CFR 0.152.
 */
package whatap.diagnosis;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.zip.GZIPOutputStream;
import whatap.agent.Logger;
import whatap.agent.conf.ConfDiagnosis;
import whatap.util.DateUtil;
import whatap.util.FileUtil;
import whatap.util.ThreadUtil;

public class DiagnosisAgent
extends Thread {
    private static DiagnosisAgent instance;
    int diagnosis_thread_order = 0;
    boolean thead_dump_stop_log = true;
    long thread_dump_idx = 0L;
    String filex;

    public static DiagnosisAgent getInstasnce() {
        if (instance == null) {
            instance = new DiagnosisAgent();
            instance.setDaemon(true);
            instance.setName("WhaTap-DiagnosisAgent");
            instance.setPriority(1);
            instance.start();
        }
        return instance;
    }

    public void run() {
        while (true) {
            ThreadUtil.sleep(ConfDiagnosis.diagnosis_interval);
            if (!ConfDiagnosis.diagnosis_enabled) continue;
            this.process();
        }
    }

    private void process() {
        if (ConfDiagnosis.diagnosis_thread_dump_enabled) {
            this.stackdump();
        } else {
            this.thread_dump_idx = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stackdump() {
        if (this.thread_dump_idx == 0L) {
            this.filex = DateUtil.format(System.currentTimeMillis(), "yyyyMMdd-HHmm");
            Logger.yellow("diagnosis", "start thread dump file-id=" + this.filex);
            this.thead_dump_stop_log = true;
        }
        if (this.thread_dump_idx >= (long)ConfDiagnosis.diagnosis_thread_dump_count) {
            if (this.thead_dump_stop_log) {
                this.thead_dump_stop_log = false;
                Logger.yellow("diagnosis", "stop thread dump file-id=" + this.filex + " idx=" + this.thread_dump_idx);
            }
            return;
        }
        GZIPOutputStream pw = null;
        try {
            File dir = new File(ConfDiagnosis.diagnosis_dir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            ++this.thread_dump_idx;
            File file = new File(dir, "thread-dump-" + this.filex + ".gz");
            pw = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file, true)));
            DiagnosisAgent.dumpThread(pw, this.thread_dump_idx);
            pw.flush();
        }
        catch (Throwable t) {
            try {
                Logger.red(t.toString());
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                FileUtil.close(pw);
            }
        }
        FileUtil.close(pw);
    }

    static void dumpThread(OutputStream out, long id) throws IOException {
        ThreadMXBean tmb = ManagementFactory.getThreadMXBean();
        int thcount = tmb.getThreadCount();
        int daemon = tmb.getDaemonThreadCount();
        long started = tmb.getTotalStartedThreadCount();
        out.write(DiagnosisAgent.b(""));
        out.write(DiagnosisAgent.b("WhaTap thread dump " + System.getProperty("java.vm.name")));
        out.write(DiagnosisAgent.b("\n"));
        out.write(DiagnosisAgent.b("[" + id + "] "));
        out.write(DiagnosisAgent.b(DateUtil.format(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss")));
        out.write(DiagnosisAgent.b(" Thread started=" + started + " count=" + thcount + " daemon=" + daemon));
        out.write(DiagnosisAgent.b("\n"));
        long[] thread = tmb.getAllThreadIds();
        for (int i = 0; i < thread.length; ++i) {
            ThreadInfo f = tmb.getThreadInfo(thread[i], 500);
            if (f == null) continue;
            out.write(DiagnosisAgent.b("\n"));
            StackTraceElement[] se = f.getStackTrace();
            if (se != null && se.length > 0) {
                out.write(DiagnosisAgent.b(ThreadUtil.getThreadHead(f)));
                out.write(DiagnosisAgent.b("\n"));
                out.write(DiagnosisAgent.b("   java.lang.Thread.State: " + (Object)((Object)f.getThreadState())));
                out.write(DiagnosisAgent.b("\n"));
                out.write(DiagnosisAgent.b(ThreadUtil.getDumpStack(se)));
                out.write(DiagnosisAgent.b("\n"));
                continue;
            }
            out.write(DiagnosisAgent.b(ThreadUtil.getThreadHead(f) + " " + f.getThreadState().toString().toLowerCase()));
            out.write(DiagnosisAgent.b("\n"));
        }
    }

    static byte[] b(String s) {
        return s.getBytes();
    }
}

