/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.sql;

import whatap.util.StringIntMap;

public class DBType {
    public static final int oracle = 1;
    public static final int postgresql = 2;
    public static final int mysql = 3;
    public static final int mariadb = 4;
    public static final int tibero = 5;
    public static final int db2 = 6;
    public static final int mssql = 7;
    public static final int fake = 8;
    public static final int aws_mysql = 9;
    private static StringIntMap map = new StringIntMap();

    public static int getType(String className) {
        if (className.startsWith("org/postgresql")) {
            return 2;
        }
        if (className.startsWith("org/mariadb")) {
            return 4;
        }
        if (className.startsWith("com/tmax/tibero")) {
            return 5;
        }
        if (className.startsWith("oracle")) {
            return 1;
        }
        if (className.startsWith("com/ibm/db2")) {
            return 6;
        }
        if (className.startsWith("com/mysql")) {
            return 3;
        }
        if (className.startsWith("software/aws/rds/jdbc/mysql/shading/com/mysql")) {
            return 9;
        }
        if (className.startsWith("com/microsoft/sqlserver")) {
            return 7;
        }
        if (className.startsWith("jdbc/Fake")) {
            return 8;
        }
        return 0;
    }

    public static String getString(int dbtype) {
        switch (dbtype) {
            case 3: {
                return "mysql";
            }
            case 1: {
                return "oracle";
            }
            case 2: {
                return "postgresql";
            }
            case 4: {
                return "mariadb";
            }
            case 5: {
                return "tibero";
            }
            case 6: {
                return "db2";
            }
            case 7: {
                return "mssql";
            }
            case 8: {
                return "fake";
            }
            case 9: {
                return "aws_mysql";
            }
        }
        return "none";
    }

    public static int getDBCodeForDBName(String dbname) {
        return map.get(dbname);
    }

    static {
        map.put("oracle", 1);
        map.put("postgresql", 2);
        map.put("mysql", 3);
        map.put("mariadb", 4);
        map.put("tibero", 5);
        map.put("db2", 6);
        map.put("mssql", 7);
        map.put("aws_mysql", 9);
        map.put("fake", 8);
    }
}

