/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.httpc;

import java.util.HashMap;
import java.util.Map;
import whatap.agent.trace.HookArgs;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.httpc.ForApacheSoapRpc;
import whatap.agent.trace.httpc.ForDefault;
import whatap.agent.trace.httpc.ForHttpClient;
import whatap.agent.trace.httpc.ForHttpClient40;
import whatap.agent.trace.httpc.ForHttpClient43;
import whatap.agent.trace.httpc.ForHttpClient50;
import whatap.agent.trace.httpc.ForHttpURLConnection;
import whatap.agent.trace.httpc.ForJCoFuntion;
import whatap.agent.trace.httpc.ForNettyHttpRequest;
import whatap.agent.trace.httpc.ForRibbonLB;
import whatap.agent.trace.httpc.ForSpringRest;
import whatap.agent.trace.httpc.ForTpmonitor;
import whatap.agent.trace.httpc.ForWeblogicHttpURLConnection;
import whatap.lang.step.HttpcStepX;

public class HttpcTraceHelper {
    static Map<String, IHelper> handlers = new HashMap<String, IHelper>();
    private static IHelper defaultObj;

    static void put(String name, IHelper o) {
        handlers.put(name.replace('.', '/'), o);
    }

    public static IHelper start(TraceContext ctx, HttpcStepX step, HookArgs hookPoint) {
        IHelper plug = handlers.get(hookPoint.class1);
        if (plug == null) {
            boolean ok = defaultObj.start(ctx, step, hookPoint);
            return ok ? defaultObj : null;
        }
        boolean ok = plug.start(ctx, step, hookPoint);
        return ok ? plug : null;
    }

    static {
        HttpcTraceHelper.put("weblogic.net.http.HttpURLConnection", new ForWeblogicHttpURLConnection());
        HttpcTraceHelper.put("sun.net.www.protocol.http.HttpURLConnection", new ForHttpURLConnection());
        HttpcTraceHelper.put("org.apache.commons.httpclient.HttpClient", new ForHttpClient());
        HttpcTraceHelper.put("org.apache.http.impl.client.InternalHttpClient", new ForHttpClient43());
        HttpcTraceHelper.put("org.apache.http.impl.client.MinimalHttpClient", new ForHttpClient43());
        HttpcTraceHelper.put("org.apache.http.impl.client.AbstractHttpClient", new ForHttpClient40());
        HttpcTraceHelper.put("org.apache.hc.client5.http.impl.classic.InternalHttpClient", new ForHttpClient50());
        HttpcTraceHelper.put("org.apache.hc.client5.http.impl.classic.MinimalHttpClient", new ForHttpClient50());
        HttpcTraceHelper.put("com.netflix.ribbon.transport.netty.http.LoadBalancingHttpClient", new ForRibbonLB());
        HttpcTraceHelper.put("org/springframework/web/client/AbstractClientHttpRequest", new ForSpringRest("SpringRest"));
        HttpcTraceHelper.put("org/springframework/web/client/Netty4ClientHttpRequest", new ForSpringRest("SpringNetty"));
        HttpcTraceHelper.put("org/springframework/web/client/OkHttpClientHttpRequest", new ForSpringRest("SpringOkHttp"));
        HttpcTraceHelper.put("tmax/webt/WebtRemoteService", new ForTpmonitor("WebT"));
        HttpcTraceHelper.put("weblogic/wtc/gwt/TuxedoConnection", new ForTpmonitor("TUX"));
        HttpcTraceHelper.put("bea/jolt/pool/SessionPool", new ForTpmonitor("JOLT"));
        HttpcTraceHelper.put("com/netflix/ribbon/transport/netty/http/LoadBalancingHttpClient", new ForRibbonLB());
        HttpcTraceHelper.put("io/reactivex/netty/protocol/http/client/HttpClientImpl", new ForNettyHttpRequest());
        HttpcTraceHelper.put("com/sap/conn/jco/JCoFunction", new ForJCoFuntion());
        HttpcTraceHelper.put("org/apache/soap/rpc/Call", new ForApacheSoapRpc());
        defaultObj = new ForDefault();
    }

    public static interface IHelper {
        public boolean start(TraceContext var1, HttpcStepX var2, HookArgs var3);

        public HttpcEndValue end(TraceContext var1, HookArgs var2, Throwable var3);
    }

    public static class HttpcEndValue {
        public long pcode;
        public int oid;
        public long seq;
        public int status;
        public String status_reason;
        public Throwable exception;
    }
}

