/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import java.util.Enumeration;
import whatap.agent.ParamSecurity;
import whatap.agent.api.trace.Request;
import whatap.agent.conf.ConfTrace;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.TraceContext;
import whatap.lang.ref.BYTE;
import whatap.lang.step.SecureMsgStep;
import whatap.util.HashUtil;
import whatap.util.StringUtil;

public class TraceHttpUtil {
    public static void dumpPrameter(Request request, TraceContext ctx) {
        if (ConfTrace.trace_http_parameter_enabled && (ConfTrace.trace_http_parameter_url_prefix == null || ctx.service_name.indexOf(ConfTrace.trace_http_parameter_url_prefix) >= 0)) {
            if (ConfTrace.trace_http_parameter_keys != null) {
                TraceHttpUtil.doDump(request, ctx, ConfTrace.trace_http_parameter_keys);
            } else {
                TraceHttpUtil.doDump(request, ctx);
            }
        }
    }

    public static void doDump(Request request, TraceContext ctx) {
        Enumeration en = request.getParameterNames();
        if (en != null) {
            int start_time = ctx.getElapsedTime();
            int hash = HashUtil.hash("HTTP-PARAMETERS");
            DataTextAgent.MESSAGE.add(hash, "HTTP-PARAMETERS");
            SecureMsgStep step = new SecureMsgStep();
            step.hash = hash;
            step.start_time = start_time;
            StringBuilder vb = new StringBuilder();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                vb.append(key).append("=").append(StringUtil.limiting(request.getParameter(key), 1024)).append("\n");
            }
            BYTE crc = new BYTE();
            step.value = TraceHttpUtil.encrypt(vb.toString(), crc);
            step.crc = crc.value;
            ctx.profile.addTail(step);
        }
    }

    public static void doDump(Request request, TraceContext ctx, String[] keys) {
        int start_time = ctx.getElapsedTime();
        int hash = HashUtil.hash("HTTP-PARAMETERS");
        DataTextAgent.MESSAGE.add(hash, "HTTP-PARAMETERS");
        SecureMsgStep step = new SecureMsgStep();
        step.hash = hash;
        step.start_time = start_time;
        StringBuilder vb = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String value = request.getParameter(key);
            if (value == null) continue;
            vb.append(key).append("=").append(StringUtil.limiting(value, 1024)).append("\n");
        }
        BYTE crc = new BYTE();
        step.value = TraceHttpUtil.encrypt(vb.toString(), crc);
        step.crc = crc.value;
        ctx.profile.addTail(step);
    }

    private static byte[] encrypt(String p, BYTE crc) {
        if (p.length() == 0) {
            return null;
        }
        byte[] b = p.getBytes();
        b = ParamSecurity.encrypt(b, crc);
        return b;
    }
}

