/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import java.util.Enumeration;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.TraceContext;
import whatap.lang.step.MessageStep;
import whatap.lang.step.Step;
import whatap.util.HashUtil;
import whatap.util.KeyGen;
import whatap.util.LongEnumer;
import whatap.util.LongKeyLinkedMap;
import whatap.util.LongKeyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceContextManager {
    private static LongKeyMap<TraceContext> entry = new LongKeyMap(1007, 0.7f);
    private static ThreadLocal<TraceContext> local = new ThreadLocal();
    private static ThreadLocal<Object> acyncFlag = new ThreadLocal();

    public static LongEnumer keys() {
        return entry.keys();
    }

    public static int size() {
        return entry.size();
    }

    public static Enumeration<TraceContext> getContextEnumeration() {
        return entry.values();
    }

    public static LongKeyLinkedMap<TraceContext> getContextList() {
        LongKeyLinkedMap<TraceContext> out = new LongKeyLinkedMap<TraceContext>();
        try {
            Enumeration<TraceContext> tr = entry.values();
            while (tr.hasMoreElements()) {
                TraceContext ctx = tr.nextElement();
                if (ctx == null) continue;
                ctx.currentElapsed = ctx.getElapsedTime();
                out.put(ctx.txid, ctx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    public static TraceContext findThread(long threadid) {
        try {
            Enumeration<TraceContext> en = entry.values();
            while (en.hasMoreElements()) {
                TraceContext ctx = en.nextElement();
                if (ctx == null || ctx.thread.getId() != threadid) continue;
                return ctx;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static TraceContext getContext(long key) {
        return entry.get(key);
    }

    public static TraceContext getLocalContext() {
        return local.get();
    }

    public static long getCurrentTraceId() {
        TraceContext ctx = local.get();
        return ctx == null ? 0L : ctx.txid;
    }

    public static TraceContext getCurrentAsyncContext() {
        return local.get();
    }

    private static void debug(TraceContext ctx) {
        MessageStep p = new MessageStep();
        p.start_time = ctx.getElapsedTime();
        p.hash = HashUtil.hash("AsyncCtx");
        DataTextAgent.MESSAGE.add(p.hash, "AsyncCtx");
        p.desc = ctx.thread.getId() + " " + ctx.thread.getName();
        ctx.profile.add(p);
    }

    public static void start(TraceContext o) {
        local.set(o);
        entry.put(o.txid, o);
    }

    public static void end(long txid) {
        local.set(null);
        entry.remove(txid);
    }

    public static void startBatch(TraceContext o) {
        if (o.txid == 0L) {
            o.txid = KeyGen.next();
        }
        local.set(o);
        entry.put(o.txid, o);
    }

    public static void endBatch(long txid) {
        local.set(null);
        entry.remove(txid);
    }

    public static void startAsync(TraceContext o) {
        local.set(o);
        entry.put(o.txid, o);
    }

    public static void endLocalThreading(TraceContext ctx) {
        local.set(null);
    }

    public static void endAsync(long txid) {
        local.set(null);
        entry.remove(txid);
    }

    public static Step[] getTxProfile(int n) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return null;
        }
        return ctx.profile.getLastSteps(n);
    }

    public static void attach(TraceContext ctx) {
        local.set(ctx);
    }

    public static void detach() {
        local.set(null);
    }

    public static boolean isAsyncRun() {
        return acyncFlag.get() != null;
    }

    public static void closeAsync() {
        acyncFlag.set(null);
    }

    public static void openAsync() {
        acyncFlag.set("");
    }
}

