/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import java.util.HashSet;
import whatap.agent.Configure;
import whatap.agent.conf.ConfThrottle;
import whatap.lang.conf.ConfObserver;
import whatap.util.HashUtil;
import whatap.util.IPUtil;
import whatap.util.IntLinkedSet;
import whatap.util.IntSet;
import whatap.util.StringUtil;

public class Throttle {
    private static IntLinkedSet passed = new IntLinkedSet().setMax(10000);
    private static IntLinkedSet notKnown = new IntLinkedSet().setMax(10000);
    private static IntSet passingUrlSet = new IntSet();
    private static String[] passingPrefix = new String[0];
    private static boolean blocking_enabled = false;
    private static IntSet blockingUrlSet = new IntSet();
    private static IntSet blockingIPSet = new IntSet();
    private static String[] ignoreContext = new String[0];
    private static IntSet ignoreDomain = new IntSet();
    private static IntLinkedSet ignoreBlockingSet = new IntLinkedSet().setMax(1000);
    private static IntLinkedSet doneBlockingSet = new IntLinkedSet().setMax(1000);
    static Configure conf = Configure.getInstance();
    private static int valueHash = Throttle.getHash();

    public static boolean isBlocking(int urlhash, int ip) {
        if (!blocking_enabled) {
            return false;
        }
        if (blockingIPSet.contains(ip)) {
            return true;
        }
        return blockingUrlSet.contains(urlhash);
    }

    public static boolean isPassing(int hash, String url) {
        if (ConfThrottle.throttle_target_urls.size() > 0) {
            return !ConfThrottle.throttle_target_urls.contains(hash);
        }
        if (notKnown.contains(hash)) {
            return false;
        }
        if (passed.contains(hash)) {
            return true;
        }
        if (passingUrlSet.contains(hash)) {
            passed.put(hash);
            return true;
        }
        for (int i = 0; i < passingPrefix.length; ++i) {
            if (!url.startsWith(passingPrefix[i])) continue;
            passed.put(hash);
            return true;
        }
        notKnown.put(hash);
        return false;
    }

    private static IntSet getThrottleStringToHashSet(String value, String deli) {
        IntSet set = new IntSet();
        if (value != null) {
            String[] vv = StringUtil.tokenizer(value, deli);
            if (vv == null) {
                return set;
            }
            for (String x : vv) {
                if ((x = StringUtil.trimToEmpty(x)).length() <= 0) continue;
                set.put(HashUtil.hash(x));
            }
        }
        return set;
    }

    private static IntSet getThrottleIP(String value, String deli) {
        IntSet set = new IntSet();
        if (value != null) {
            String[] vv = StringUtil.tokenizer(value, deli);
            if (vv == null) {
                return set;
            }
            for (String x : vv) {
                int ip = IPUtil.toInt(StringUtil.trimToEmpty(x));
                if (ip == 0) continue;
                set.put(ip);
            }
        }
        return set;
    }

    private static String[] getThrottleIgnorePrefixl(String value, String deli) {
        HashSet<String> set = new HashSet<String>();
        if (value != null) {
            String[] vv = StringUtil.tokenizer(value, deli);
            if (vv == null) {
                return new String[0];
            }
            for (String x : vv) {
                if ((x = StringUtil.trimToEmpty(x)).length() <= 0) continue;
                set.add(x);
            }
        }
        return set.toArray(new String[set.size()]);
    }

    private static int getHash() {
        String k1 = StringUtil.trimEmpty(ConfThrottle.throttle_passing_url);
        String k2 = StringUtil.trimEmpty(ConfThrottle.throttle_passing_url_prefix);
        String k3 = StringUtil.trimEmpty(ConfThrottle.throttle_blocking_url);
        String k4 = StringUtil.trimEmpty(ConfThrottle.throttle_blocking_ip);
        String k5 = StringUtil.trimEmpty(ConfThrottle.throttle_blocking_ignore_domain);
        String k6 = StringUtil.trimEmpty(ConfThrottle.throttle_blocking_ignore_context);
        return k1.hashCode() ^ k2.hashCode() ^ k3.hashCode() ^ k4.hashCode() ^ k5.hashCode() ^ k6.hashCode();
    }

    public static boolean isIgnoreBlocking(int service_hash, String service_name, int http_host) {
        if (http_host != 0 && ignoreDomain.contains(http_host)) {
            return true;
        }
        if (ignoreContext != null) {
            if (ignoreBlockingSet.contains(service_hash)) {
                return true;
            }
            if (doneBlockingSet.contains(service_hash)) {
                return false;
            }
            for (String ctx : ignoreContext) {
                if (!service_name.startsWith(ctx)) continue;
                ignoreBlockingSet.put(service_hash);
                return true;
            }
            doneBlockingSet.put(service_hash);
        }
        return false;
    }

    static /* synthetic */ String[] access$402(String[] x0) {
        passingPrefix = x0;
        return x0;
    }

    static /* synthetic */ String[] access$1202(String[] x0) {
        ignoreContext = x0;
        return x0;
    }

    static {
        passingUrlSet = Throttle.getThrottleStringToHashSet(ConfThrottle.throttle_passing_url, ",");
        passingPrefix = Throttle.getThrottleIgnorePrefixl(ConfThrottle.throttle_passing_url_prefix, ",");
        blockingUrlSet = Throttle.getThrottleStringToHashSet(ConfThrottle.throttle_blocking_url, ",");
        blockingIPSet = Throttle.getThrottleIP(ConfThrottle.throttle_blocking_ip, ",");
        blocking_enabled = blockingUrlSet.size() > 0 || blockingIPSet.size() > 0;
        ignoreContext = StringUtil.tokenizer(ConfThrottle.throttle_blocking_ignore_context, ",");
        ignoreDomain = Throttle.getThrottleStringToHashSet(ConfThrottle.throttle_blocking_ignore_domain, ",");
        ConfObserver.add("ThrottleUtil", new Runnable(){

            public void run() {
                int newHash = Throttle.getHash();
                if (valueHash != newHash) {
                    valueHash = newHash;
                    passingUrlSet = Throttle.getThrottleStringToHashSet(ConfThrottle.throttle_passing_url, ",");
                    Throttle.access$402(Throttle.getThrottleIgnorePrefixl(ConfThrottle.throttle_passing_url_prefix, ","));
                    passed.clear();
                    notKnown.clear();
                    blockingUrlSet = Throttle.getThrottleStringToHashSet(ConfThrottle.throttle_blocking_url, ",");
                    blockingIPSet = Throttle.getThrottleIP(ConfThrottle.throttle_blocking_ip, ",");
                    blocking_enabled = blockingUrlSet.size() > 0 || blockingIPSet.size() > 0;
                    Throttle.access$1202(StringUtil.tokenizer(ConfThrottle.throttle_blocking_ignore_context, ","));
                    ignoreDomain = Throttle.getThrottleStringToHashSet(ConfThrottle.throttle_blocking_ignore_domain, ",");
                    ignoreBlockingSet.clear();
                    doneBlockingSet.clear();
                }
            }
        });
    }
}

