/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.conf.ConfTrace;
import whatap.agent.data.DataTextAgent;
import whatap.agent.data.ProfileStepThread;
import whatap.agent.data.ProfileVirtualTxThread;
import whatap.agent.trace.IProfileCollector;
import whatap.agent.trace.TraceContext;
import whatap.lang.step.MessageStep;
import whatap.lang.step.Step;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.KeyGen;

public class ProfileSplitTxCollector
implements IProfileCollector {
    protected int BUFFER_MAX = ConfTrace.trace_step_max_count;
    protected Step[] bufferParent = new Step[this.BUFFER_MAX];
    protected Step[] bufferChild = new Step[this.BUFFER_MAX];
    protected int bufferParentPos;
    public int bufferChildPos;
    public int parent_step_split_count = 0;
    public int child_split_tx_num = 1;
    public int parent_index = -1;
    protected int child_index;
    private TraceContext parent;
    static ProfileStepThread parentProfile = ProfileStepThread.getInstance();
    static ProfileVirtualTxThread profile = ProfileVirtualTxThread.getInstance();
    int childStart = 0;
    int virtual_tx_hash = 0;

    ProfileSplitTxCollector(TraceContext parent) {
        this.parent = parent;
    }

    public boolean hasStep() {
        return this.bufferChildPos > 0 || this.bufferParentPos > 0;
    }

    public synchronized void push(Step step) {
        step.parent = this.parent_index;
        this.parent_index = step.index = this.child_index++;
    }

    public synchronized void add(Step step) {
        if (this.bufferChildPos >= this.BUFFER_MAX) {
            this.send(this.child_split_tx_num, this.bufferChild);
            this.bufferChild = new Step[this.BUFFER_MAX];
            this.bufferChildPos = 0;
            ++this.child_split_tx_num;
        }
        step.parent = this.parent_index;
        step.index = this.child_index++;
        this.bufferChild[this.bufferChildPos] = step;
        ++this.bufferChildPos;
    }

    public synchronized void justAdd(Step step) {
        if (this.bufferChildPos >= this.BUFFER_MAX) {
            this.send(this.child_split_tx_num, this.bufferChild);
            this.bufferChild = new Step[this.BUFFER_MAX];
            this.bufferChildPos = 0;
            ++this.child_split_tx_num;
        }
        this.bufferChild[this.bufferChildPos] = step;
        ++this.bufferChildPos;
    }

    public void append(Step step) {
        this.add(step);
    }

    public void addTail(Step step) {
        this.add(step);
    }

    public synchronized void pop(Step step) {
        if (this.bufferChildPos >= this.BUFFER_MAX) {
            this.send(this.child_split_tx_num, this.bufferChild);
            this.bufferChild = new Step[this.BUFFER_MAX];
            this.bufferChildPos = 0;
            ++this.child_split_tx_num;
        }
        this.bufferChild[this.bufferChildPos] = step;
        ++this.bufferChildPos;
        this.parent_index = step.parent;
    }

    private void send(int inx, Step[] buff) {
        int txElapsed = this.parent.getElapsedTime();
        int childElapsed = txElapsed - this.childStart;
        String childName = this.parent.service_name + "-" + inx;
        long childTxid = KeyGen.next();
        profile.add(DateUtil.currentTime(), childName, childTxid, this.childStart, childElapsed, this.parent, buff);
        if (this.bufferParentPos >= this.BUFFER_MAX) {
            this.sendParent(this.parent_step_split_count, this.bufferParent);
            this.bufferParent = new Step[this.BUFFER_MAX];
            this.bufferParentPos = 0;
            ++this.parent_step_split_count;
        }
        if (this.virtual_tx_hash == 0) {
            this.virtual_tx_hash = HashUtil.hash("Virtual-Tx");
            DataTextAgent.MESSAGE.add(this.virtual_tx_hash, "Virtual-Tx");
        }
        MessageStep step = new MessageStep();
        step.start_time = this.childStart;
        step.hash = this.virtual_tx_hash;
        step.desc = childName + " <" + childTxid + ">";
        step.time = childElapsed;
        this.bufferParent[this.bufferParentPos] = step;
        ++this.bufferParentPos;
        this.childStart = txElapsed;
    }

    private void sendParent(int inx, Step[] buff) {
        parentProfile.add(DateUtil.currentTime(), this.parent.txid, inx, buff);
    }

    public synchronized Step[] getLastSteps(int n) {
        int cnt = this.bufferChildPos > n ? n : this.bufferChildPos;
        Step[] buff = new Step[cnt];
        int x = this.bufferChildPos - cnt;
        for (int i = 0; i < cnt; ++i) {
            buff[i] = this.bufferChild[x + i];
        }
        return buff;
    }

    public synchronized Step[] getSteps() {
        if (this.bufferParentPos == 0 && this.bufferChildPos == 0) {
            return new Step[0];
        }
        if (this.bufferParentPos == 0) {
            if (this.bufferChildPos >= this.bufferChild.length) {
                return this.bufferChild;
            }
            Step[] buff = new Step[this.bufferChildPos];
            if (this.bufferChildPos > 0) {
                System.arraycopy(this.bufferChild, 0, buff, 0, this.bufferChildPos);
            }
            return buff;
        }
        if (this.bufferChildPos == 0) {
            Step[] buff = new Step[this.bufferParentPos];
            if (this.bufferParentPos > 0) {
                System.arraycopy(this.bufferParent, 0, buff, 0, this.bufferParentPos);
            }
            return buff;
        }
        Step[] buff = new Step[this.bufferParentPos + this.bufferChildPos];
        System.arraycopy(this.bufferParent, 0, buff, 0, this.bufferParentPos);
        System.arraycopy(this.bufferChild, 0, buff, this.bufferParentPos, this.bufferChildPos);
        return buff;
    }

    public byte[] toBytes() {
        return Step.toBytes(this.getSteps());
    }

    public Step[] getStep4Error() {
        return this.getLastSteps(5);
    }

    public boolean isReal() {
        return true;
    }

    public void append(Step[] steps) {
        if (steps == null) {
            return;
        }
        for (int i = 0; i < steps.length; ++i) {
            this.add(steps[i]);
        }
    }

    public void append(int parentOffsetTime, Step[] steps) {
        if (steps == null) {
            return;
        }
        for (int i = 0; i < steps.length; ++i) {
            steps[i].start_time += parentOffsetTime;
            this.add(steps[i]);
        }
    }

    public int getSplitCount() {
        return this.parent_step_split_count;
    }

    public int length() {
        return this.parent_step_split_count * this.BUFFER_MAX + this.bufferChildPos;
    }
}

