/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.conf.ConfTrace;
import whatap.agent.data.ProfileStepThread;
import whatap.agent.trace.IProfileCollector;
import whatap.agent.trace.TraceContext;
import whatap.lang.step.Step;
import whatap.util.DateUtil;

public class ProfileLargeCollector
implements IProfileCollector {
    protected int BUFFER_MAX = ConfTrace.trace_step_max_count;
    protected Step[] buffer = new Step[this.BUFFER_MAX];
    protected int buffer_pos;
    public int split_count = 0;
    public int position = 0;
    public int parent_index = -1;
    private TraceContext parent;
    static ProfileStepThread profile = ProfileStepThread.getInstance();

    ProfileLargeCollector(TraceContext parent) {
        this.parent = parent;
    }

    public boolean hasStep() {
        return this.position > 0;
    }

    public synchronized void push(Step step) {
        step.index = this.position;
        step.parent = this.parent_index;
        this.parent_index = this.position++;
    }

    public synchronized void add(Step step) {
        if (this.buffer_pos >= this.BUFFER_MAX) {
            this.send(this.split_count, this.buffer);
            this.buffer = new Step[this.BUFFER_MAX];
            this.buffer_pos = 0;
            ++this.split_count;
        }
        step.index = this.position++;
        step.parent = this.parent_index;
        this.buffer[this.buffer_pos] = step;
        ++this.buffer_pos;
    }

    public synchronized void justAdd(Step step) {
        if (this.buffer_pos >= this.BUFFER_MAX) {
            this.send(this.split_count, this.buffer);
            this.buffer = new Step[this.BUFFER_MAX];
            this.buffer_pos = 0;
            ++this.split_count;
        }
        this.buffer[this.buffer_pos] = step;
        ++this.buffer_pos;
        ++this.position;
    }

    public void append(Step step) {
        this.add(step);
    }

    public void addTail(Step step) {
        this.add(step);
    }

    public synchronized void pop(Step step) {
        if (this.buffer_pos >= this.BUFFER_MAX) {
            this.send(this.split_count, this.buffer);
            this.buffer = new Step[this.BUFFER_MAX];
            this.buffer_pos = 0;
            ++this.split_count;
        }
        this.buffer[this.buffer_pos] = step;
        ++this.buffer_pos;
        this.parent_index = step.parent;
    }

    private void send(int inx, Step[] buff) {
        profile.add(DateUtil.currentTime(), this.parent.txid, inx, buff);
    }

    public synchronized Step[] getLastSteps(int n) {
        int cnt = this.buffer_pos > n ? n : this.buffer_pos;
        Step[] buff = new Step[cnt];
        int x = this.buffer_pos - cnt;
        for (int i = 0; i < cnt; ++i) {
            buff[i] = this.buffer[x + i];
        }
        return buff;
    }

    public synchronized Step[] getSteps() {
        if (this.buffer_pos >= this.buffer.length) {
            return this.buffer;
        }
        Step[] buff = new Step[this.buffer_pos];
        if (this.buffer_pos > 0) {
            System.arraycopy(this.buffer, 0, buff, 0, this.buffer_pos);
        }
        return buff;
    }

    public byte[] toBytes() {
        return Step.toBytes(this.getSteps());
    }

    public Step[] getStep4Error() {
        return this.getLastSteps(5);
    }

    public boolean isReal() {
        return true;
    }

    public void append(Step[] steps) {
        if (steps == null) {
            return;
        }
        for (int i = 0; i < steps.length; ++i) {
            this.add(steps[i]);
        }
    }

    public void append(int parentOffsetTime, Step[] steps) {
        if (steps == null) {
            return;
        }
        for (int i = 0; i < steps.length; ++i) {
            steps[i].start_time += parentOffsetTime;
            this.add(steps[i]);
        }
    }

    public int getSplitCount() {
        return this.split_count;
    }

    public int length() {
        return this.split_count * this.BUFFER_MAX + this.position;
    }
}

