/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.conf.ConfMethodStat;
import whatap.lang.conf.ConfObserver;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.util.IntIntMap;
import whatap.util.StringUtil;
import whatap.util.SysJMX;

public class MethodStat {
    private static IntIntMap idxTable = new IntIntMap().setNullValue(-1);
    private static Ctx[] table = new Ctx[4000];
    private static int size = 0;
    private static long reset_time = System.currentTimeMillis();
    private static boolean resOn = false;

    public static synchronized int add(int hash, String name) {
        int idx = idxTable.get(hash);
        if (idx >= 0) {
            return idx;
        }
        if (size >= table.length) {
            return -1;
        }
        idx = size++;
        MethodStat.table[idx] = new Ctx(hash, name);
        idxTable.put(hash, idx);
        return idx;
    }

    public static int size() {
        return size;
    }

    public static Object start(int inx) {
        TIME t = new TIME(inx, System.currentTimeMillis());
        ++MethodStat.table[inx].active;
        if (resOn) {
            t.scpu = SysJMX.getCurrentThreadCPUnano();
            t.smem = SysJMX.getCurrentThreadAllocBytes();
        }
        return t;
    }

    public static void end(Object stat, Throwable thr) {
        try {
            TIME t = (TIME)stat;
            Ctx x = table[t.inx];
            --x.active;
            x.count++;
            Ctx ctx = x;
            ctx.time = ctx.time + (System.currentTimeMillis() - t.stime);
            if (t.scpu > 0L) {
                x.cpu += SysJMX.getCurrentThreadCPUnano() - t.scpu;
            }
            if (t.smem > 0L) {
                x.mem += SysJMX.getCurrentThreadAllocBytes() - t.smem;
            }
            if (thr != null) {
                x.error++;
                x.errorMessage = thr.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void reset() {
        reset_time = System.currentTimeMillis();
        try {
            Ctx x;
            for (int i = 0; i < size && (x = table[i]) != null; ++i) {
                x.active = 0;
                x.count = 0L;
                x.error = 0L;
                x.time = 0L;
                x.cpu = 0L;
                x.mem = 0L;
                x.errorMessage = null;
                x.init_time = MethodStat.reset_time;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static MapValue getEntry(int startIndex, int max, String filter) {
        if (max <= 0) {
            max = 100;
        }
        if (StringUtil.isEmpty(filter)) {
            filter = null;
        }
        MapValue m = new MapValue();
        ListValue index = m.newList("index");
        ListValue hash = m.newList("hash");
        ListValue name = m.newList("name");
        ListValue count = m.newList("count");
        ListValue error = m.newList("error");
        ListValue timeavg = m.newList("time_avg");
        ListValue timesum = m.newList("time_sum");
        ListValue initTime = m.newList("init_time");
        ListValue cpu_sum = m.newList("cpu_sum");
        ListValue mem_sum = m.newList("mem_sum");
        ListValue errorMessage = m.newList("errorMessage");
        int rowCount = 0;
        int len = size;
        for (int i = startIndex; hash.size() < max && i < len; ++i) {
            Ctx x = table[i];
            if (filter != null && x.name.indexOf(filter) < 0) continue;
            ++rowCount;
            index.add(i);
            hash.add(x.hash);
            name.add(x.name);
            count.add(x.count);
            error.add(x.error);
            timeavg.add(x.count == 0L ? 0L : x.time / x.count);
            timesum.add(x.time);
            initTime.add(x.init_time);
            cpu_sum.add(x.cpu);
            mem_sum.add(x.mem);
            errorMessage.add(x.errorMessage == null ? "" : x.errorMessage);
        }
        m.put("resetTime", reset_time);
        m.put("totalCount", size);
        m.put("rowCount", rowCount);
        return m;
    }

    static {
        resOn = ConfMethodStat.method_stat_res_enabled;
        ConfObserver.add("MethodStat", new Runnable(){

            public void run() {
                resOn = ConfMethodStat.method_stat_res_enabled;
            }
        });
    }

    static class TIME {
        int inx;
        long stime;
        long scpu;
        long smem;

        public TIME(int inx, long stime) {
            this.inx = inx;
            this.stime = stime;
        }
    }

    static class Ctx {
        private long time;
        public long cpu;
        public long mem;
        private long count;
        private int hash;
        private String name;
        private long error;
        private long init_time;
        public int active;
        public String errorMessage;

        public Ctx(int hash, String name) {
            this.hash = hash;
            this.name = name;
            this.init_time = System.currentTimeMillis();
        }
    }
}

