/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.conf.ConfLogSink;
import whatap.agent.data.DataTextAgent;
import whatap.lang.ref.LONG;
import whatap.lang.step.HttpcStepX;
import whatap.logsink.LineLog;
import whatap.logsink.fw.LogTracer;
import whatap.util.DateUtil;
import whatap.util.IPUtil;
import whatap.util.IntKeyLinkedMap;

public class LogSinkRemoteAccessStatus {
    private static final String REMOTE_ACCESS_STATUS = "#RemoteAccessStatus";
    static IntKeyLinkedMap<LONG> lastOkDbcTime = new IntKeyLinkedMap<LONG>(){

        @Override
        protected LONG create(int key) {
            return new LONG();
        }
    }.setMax(1000);
    private static IntKeyLinkedMap<String> hashDBcMap = new IntKeyLinkedMap(107, 0.7f).setMax(500);
    static long last_dbc_error = 0L;
    static IntKeyLinkedMap<LONG> lastErrLogTime = new IntKeyLinkedMap<LONG>(){

        @Override
        protected LONG create(int key) {
            return new LONG();
        }
    }.setMax(100);
    static IntKeyLinkedMap<LONG> lastOkLogTime = new IntKeyLinkedMap<LONG>(){

        @Override
        protected LONG create(int key) {
            return new LONG();
        }
    }.setMax(100);
    static long last_socket_error;

    public static void dbcOk(int dbc_hash, Object poolClass, Object pool) {
        if (!ConfLogSink.logsink_rt_dbc_ok_enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        LONG last = lastOkDbcTime.intern(dbc_hash);
        if (now - last.value < ConfLogSink.logsink_rt_ok_interval) {
            return;
        }
        last.value = now;
        String dbc = DataTextAgent.DbcUrlMap.get(dbc_hash);
        if (dbc == null) {
            return;
        }
        if (pool != null) {
            hashDBcMap.put(System.identityHashCode(pool), dbc);
        } else if (poolClass != null) {
            hashDBcMap.put(poolClass.hashCode(), dbc);
        }
        LineLog lineLog = new LineLog();
        lineLog.time = DateUtil.currentTime();
        lineLog.category = REMOTE_ACCESS_STATUS;
        lineLog.content = "ok";
        lineLog.tags.put("source", "db");
        lineLog.tags.put("level", "ok");
        lineLog.tags.put("dbc", dbc);
        LogTracer.send(lineLog);
    }

    public static void dbcError(String message, Object poolClass, Object pool) {
        if (!ConfLogSink.logsink_rt_dbc_error_enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - last_dbc_error < ConfLogSink.logsink_rt_error_interval) {
            return;
        }
        last_dbc_error = now;
        String dbc = null;
        if (pool != null) {
            dbc = hashDBcMap.get(System.identityHashCode(pool));
        } else if (poolClass != null) {
            dbc = hashDBcMap.get(poolClass.hashCode());
        }
        LineLog lineLog = new LineLog();
        lineLog.time = DateUtil.currentTime();
        lineLog.category = REMOTE_ACCESS_STATUS;
        lineLog.content = message;
        lineLog.tags.put("source", "db");
        lineLog.tags.put("level", "error");
        if (dbc != null) {
            lineLog.tags.put("dbc", dbc);
        }
        LogTracer.send(lineLog);
    }

    public static void httpError(String hostName, String httpcUrl, HttpcStepX step) {
        if (!ConfLogSink.logsink_rt_httpc_error_enabled) {
            return;
        }
        if (hostName == null) {
            return;
        }
        long now = System.currentTimeMillis();
        LONG last = lastErrLogTime.intern(hostName.hashCode());
        if (now - last.value < ConfLogSink.logsink_rt_error_interval) {
            return;
        }
        last.value = now;
        LineLog lineLog = new LineLog();
        lineLog.time = DateUtil.currentTime();
        lineLog.category = REMOTE_ACCESS_STATUS;
        lineLog.content = "fail";
        lineLog.tags.put("source", "httpcall");
        lineLog.tags.put("level", "error");
        lineLog.tags.put("target", hostName);
        if (step.port > 0) {
            lineLog.tags.put("port", Integer.toString(step.port));
        }
        if (step.driver != null) {
            lineLog.tags.put("driver", step.driver);
        }
        if (httpcUrl != null) {
            lineLog.fields.put("path", httpcUrl);
        }
        lineLog.tags.put("status", Integer.toString(step.status));
        LogTracer.send(lineLog);
    }

    public static void httpError(String hostName, String httpcUrl, HttpcStepX step, Throwable thr) {
        if (!ConfLogSink.logsink_rt_httpc_error_enabled) {
            return;
        }
        if (hostName == null) {
            return;
        }
        long now = System.currentTimeMillis();
        LONG last = lastErrLogTime.intern(hostName.hashCode());
        if (now - last.value < ConfLogSink.logsink_rt_error_interval) {
            return;
        }
        last.value = now;
        LineLog lineLog = new LineLog();
        lineLog.time = DateUtil.currentTime();
        lineLog.category = REMOTE_ACCESS_STATUS;
        lineLog.content = thr.getMessage();
        lineLog.tags.put("source", "httpcall");
        lineLog.tags.put("level", "error");
        lineLog.tags.put("target", hostName);
        if (step.port > 0) {
            lineLog.tags.put("port", Integer.toString(step.port));
        }
        if (step.driver != null) {
            lineLog.tags.put("driver", step.driver);
        }
        if (httpcUrl != null) {
            lineLog.fields.put("path", httpcUrl);
        }
        lineLog.tags.put("exception", LogSinkRemoteAccessStatus.nameOnly(thr));
        LogTracer.send(lineLog);
    }

    private static String nameOnly(Throwable thr) {
        String className = thr.getClass().getName();
        int x = className.lastIndexOf(46);
        if (x > 0) {
            return className.substring(x + 1);
        }
        return className;
    }

    public static void socketError(String level, byte[] ip, int port, String message) {
        if (!ConfLogSink.logsink_rt_socket_enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - last_socket_error < ConfLogSink.logsink_rt_error_interval) {
            return;
        }
        last_socket_error = now;
        LineLog lineLog = new LineLog();
        lineLog.time = DateUtil.currentTime();
        lineLog.category = REMOTE_ACCESS_STATUS;
        lineLog.content = message;
        lineLog.tags.put("source", "socket");
        lineLog.tags.put("level", level);
        if (ip != null) {
            lineLog.tags.put("target", IPUtil.toString(ip));
        }
        if (port > 0) {
            lineLog.tags.put("port", Integer.toString(port));
        }
        LogTracer.send(lineLog);
    }

    public static void httpOk(String hostName, HttpcStepX step) {
        if (!ConfLogSink.logsink_rt_httpc_ok_enabled) {
            return;
        }
        if (hostName == null) {
            return;
        }
        long now = System.currentTimeMillis();
        LONG last = lastOkLogTime.intern(hostName.hashCode());
        if (now - last.value < ConfLogSink.logsink_rt_ok_interval) {
            return;
        }
        last.value = now;
        LineLog lineLog = new LineLog();
        lineLog.time = DateUtil.currentTime();
        lineLog.category = REMOTE_ACCESS_STATUS;
        lineLog.content = "ok";
        lineLog.tags.put("source", "httpcall");
        lineLog.tags.put("level", "ok");
        lineLog.tags.put("status", Integer.toString(step.status));
        lineLog.tags.put("target", hostName);
        if (step.port > 0) {
            lineLog.tags.put("port", Integer.toString(step.port));
        }
        if (step.driver != null) {
            lineLog.tags.put("driver", step.driver);
        }
        LogTracer.send(lineLog);
    }
}

