/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.util.IntKeyLinkedMap;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConPool {
    static StringKeyLinkedMap<IntKeyLinkedMap<WeakReference<Object>>> pools = new StringKeyLinkedMap<IntKeyLinkedMap<WeakReference<Object>>>(){

        @Override
        protected IntKeyLinkedMap<WeakReference<Object>> create(String key) {
            return new IntKeyLinkedMap().setMax(100);
        }
    }.setMax(100);
    public static final Enumeration<WeakReference<Object>> empty = new Enumeration<WeakReference<Object>>(){

        @Override
        public WeakReference<Object> nextElement() {
            return null;
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }
    };

    public static void regist(String id, Object conPool) {
        if (conPool == null) {
            return;
        }
        int key = System.identityHashCode(conPool);
        IntKeyLinkedMap<WeakReference<Object>> table = pools.intern(id);
        if (!table.containsKey(key)) {
            table.put(key, new WeakReference<Object>(conPool));
            Logger.green("regist-pool id=" + id + " class=" + conPool.getClass().getName());
        }
    }

    public static Enumeration<WeakReference<Object>> getObjectEnum(String name) {
        IntKeyLinkedMap<WeakReference<Object>> pool = pools.get(name);
        if (pool != null) {
            return pool.values();
        }
        return empty;
    }

    public static boolean isEmpty(Object o) {
        return o == empty || o == null;
    }

    public static StringEnumer keys() {
        return pools.keys();
    }
}

