/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.topology;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import whatap.agent.SecurityMaster;
import whatap.agent.boot.JavaTypeEnum;
import whatap.agent.boot.ProcessTypeDetector;
import whatap.lang.topology.NODE;
import whatap.util.DateUtil;
import whatap.util.FileUtil;
import whatap.util.IPUtil;
import whatap.util.StringSet;
import whatap.util.StringUtil;
import whatap.util.SysJMX;
import whatap.util.SystemUtil;

public class StatusDetector {
    public NODE process() {
        NODE node;
        String stat = StatusDetector.netstat();
        if (StringUtil.isEmpty(stat)) {
            node = new NODE();
        } else {
            try {
                node = this.parse(stat);
            }
            catch (Exception e) {
                node = new NODE();
                e.printStackTrace();
            }
        }
        node.attr.put("type", "java");
        String was = JavaTypeEnum.values.get(ProcessTypeDetector.findType());
        node.attr.put("was", was);
        node.attr.put("time", DateUtil.now());
        int ip = SecurityMaster.getInstance().IP;
        node.attr.put("ip", IPUtil.toString(ip));
        node.attr.put("pid", SysJMX.getProcessPID());
        node.attr.put("pname", SysJMX.getProcessName());
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String netstat() {
        block8: {
            String string;
            String cmd;
            InputStream es;
            OutputStream os;
            InputStream is;
            block7: {
                is = null;
                os = null;
                es = null;
                cmd = "netstat -an -t";
                if (SystemUtil.IS_MAC) {
                    cmd = "netstat -an -p tcp";
                    break block7;
                }
                if (!SystemUtil.IS_WINDOWS) break block7;
                String string2 = "";
                FileUtil.close(is);
                FileUtil.close(os);
                FileUtil.close(es);
                return string2;
            }
            try {
                Process process = Runtime.getRuntime().exec(cmd);
                is = process.getInputStream();
                os = process.getOutputStream();
                es = process.getErrorStream();
                byte[] isBytes = FileUtil.readAll(is);
                string = new String(isBytes);
            }
            catch (Throwable th) {
                try {
                    th.printStackTrace();
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    FileUtil.close(is);
                    FileUtil.close(os);
                    FileUtil.close(es);
                }
            }
            FileUtil.close(is);
            FileUtil.close(os);
            FileUtil.close(es);
            return string;
        }
        return null;
    }

    protected NODE parse(String netstat) throws IOException {
        NODE node = new NODE();
        StringSet localIPs = StatusDetector.localIps();
        BufferedReader r = new BufferedReader(new StringReader(netstat));
        String line = r.readLine();
        while (line != null) {
            if (line.startsWith("tcp")) {
                this.parse(node, line, localIPs);
            }
            line = r.readLine();
        }
        return node;
    }

    private void parse(NODE n, String line, StringSet localIPs) {
        String[] tokens = StringUtil.tokenizer(line, "\t\n ");
        if (!line.startsWith("tcp")) {
            return;
        }
        if ("LISTEN".equals(tokens[5])) {
            n.addListen(localIPs, tokens[3]);
        } else {
            n.addOutter(tokens[3], tokens[4]);
        }
    }

    private static StringSet localIps() {
        StringSet ipSet = new StringSet();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    ipSet.put(inetAddress.getHostAddress());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ipSet;
    }

    public static void main(String[] args) {
        System.out.println(new StatusDetector().process());
    }
}

