/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.test;

import whatap.agent.Configure;
import whatap.agent.boot.AgentBoot;
import whatap.agent.conf.ConfSysMon;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.task.res.SystemECSTask;
import whatap.agent.counter.task.res.SystemJMXTask;
import whatap.agent.counter.task.res.SystemKubeTask;
import whatap.agent.counter.task.res.SystemLinuxTask;
import whatap.agent.counter.task.res.SystemOshiTask;
import whatap.agent.counter.task.res.SystemShellTask;
import whatap.agent.counter.task.res.SystemSigarTask;
import whatap.agent.logo.Logo;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.CounterPack1;
import whatap.util.DateUtil;
import whatap.util.FormatUtil;
import whatap.util.JarUtil;
import whatap.util.ThreadUtil;

public class ResMon {
    protected byte systype = 1;
    protected ICounterTask sysmon = null;

    public static void main(String[] args) {
        String home = JarUtil.getJarLocation(AgentBoot.class);
        System.setProperty("whatap.home", home);
        Configure.getInstance().waitForInit();
        System.setProperty("whatap.logo", "whatap.logo");
        Logo.print();
        final ResMon r = new ResMon();
        r.update();
        ConfObserver.add("SystemCPU", new Runnable(){

            public void run() {
                r.update();
            }
        });
        int x = 0;
        while (true) {
            ThreadUtil.sleep(3000L);
            CounterPack1 p = new CounterPack1();
            r.sysmon.process(p);
            if (x++ % 10 == 0) {
                System.out.println("       cpu\tpcpu\tmem\tdisk");
            }
            System.out.println(DateUtil.hhmmss(System.currentTimeMillis()) + " " + ResMon.toStr(p.cpu) + "\t" + ResMon.toStr(p.cpu_proc) + "\t" + ResMon.toStr(p.mem) + "\t" + ResMon.toStr(p.disk));
        }
    }

    private void update() {
        byte thisType = ConfSysMon.findType();
        if (this.systype == thisType) {
            return;
        }
        this.systype = thisType;
        switch (thisType) {
            case 2: {
                this.sysmon = new SystemECSTask();
                System.out.println("System CPU collected by 'ECS' task");
                break;
            }
            case 3: {
                this.sysmon = new SystemKubeTask();
                System.out.println("System CPU collected by 'KUBE' task");
                break;
            }
            case 4: {
                this.sysmon = new SystemLinuxTask();
                System.out.println("System CPU collected by 'LNUX /proc/stat'");
                break;
            }
            case 5: {
                this.sysmon = new SystemJMXTask();
                System.out.println("System CPU collected by 'JMX' task");
                break;
            }
            case 6: {
                this.sysmon = new SystemShellTask();
                System.out.println("System CPU collected by 'Shell'");
                break;
            }
            case 7: {
                this.sysmon = new SystemSigarTask();
                System.out.println("System CPU collected by 'Sigar'");
                break;
            }
            case 8: {
                this.sysmon = new SystemOshiTask();
                System.out.println("System CPU collected by 'OSHI'");
                break;
            }
            default: {
                this.sysmon = new SystemJMXTask();
                System.out.println("System CPU collected by 'JMX' task(none)");
            }
        }
    }

    private static String toStr(float f) {
        return FormatUtil.print(Float.valueOf(f), "#,##0.0#");
    }
}

